/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;

public class SimpleHashRequest
implements HashRequest {
    private final ByteSource source;
    private final ByteSource salt;
    private final int iterations;
    private final String algorithmName;

    public SimpleHashRequest(String algorithmName, ByteSource source, ByteSource salt, int iterations) {
        if (source == null) {
            throw new NullPointerException("source argument cannot be null");
        }
        this.source = source;
        this.salt = salt;
        this.algorithmName = algorithmName;
        this.iterations = Math.max(0, iterations);
    }

    @Override
    public ByteSource getSource() {
        return this.source;
    }

    @Override
    public ByteSource getSalt() {
        return this.salt;
    }

    @Override
    public int getIterations() {
        return this.iterations;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }
}

