/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;

public class UserAuthAttributes {
    private final AtomicInteger numberOfDurableCQ;
    private final AuthorizeRequest authzRequest;
    private final AuthorizeRequestPP postAuthzRequest;

    public UserAuthAttributes(AuthorizeRequest authzRequest, AuthorizeRequestPP postAuthzRequest) {
        this.authzRequest = authzRequest;
        this.postAuthzRequest = postAuthzRequest;
        this.numberOfDurableCQ = new AtomicInteger();
    }

    public AuthorizeRequest getAuthzRequest() {
        return this.authzRequest;
    }

    public AuthorizeRequestPP getPostAuthzRequest() {
        return this.postAuthzRequest;
    }

    public void setDurable() {
        this.numberOfDurableCQ.incrementAndGet();
    }

    public void unsetDurable() {
        this.numberOfDurableCQ.decrementAndGet();
    }

    public boolean isDurable() {
        return this.numberOfDurableCQ.intValue() != 0;
    }
}

