/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinDiskRegionEntryHeapUUIDKey
extends VMThinDiskRegionEntryHeap {
    private static final AtomicLongFieldUpdater<VMThinDiskRegionEntryHeapUUIDKey> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMThinDiskRegionEntryHeapUUIDKey.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile Object value;
    protected DiskId id;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VMThinDiskRegionEntryHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object value) {
        this.value = value;
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        this.diskInitialize(context, value);
    }

    @Override
    public int updateAsyncEntrySize(EvictionController evictionController) {
        throw new IllegalStateException("should never be called");
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    public void setDiskId(RegionEntry oldEntry) {
        this.id = ((DiskEntry)oldEntry).getDiskId();
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore diskRecoveryStore = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl diskStore = diskRecoveryStore.getDiskStore();
        long maxOplogSize = diskStore.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, diskStore.needsLinkedList());
        DiskEntry.Helper.initialize(this, diskRecoveryStore, value);
    }

    @Override
    public Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof UUID) {
            UUID uuid = (UUID)key;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

