/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.client.internal.locator.LocatorStatusRequest;
import org.apache.geode.cache.client.internal.locator.LocatorStatusResponse;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.tcpserver.HostAddress;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.DistributedSerializableObjectConfig;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.process.ConnectionFailedException;
import org.apache.geode.internal.process.ControlNotificationHandler;
import org.apache.geode.internal.process.ControllableProcess;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.FileControllableProcess;
import org.apache.geode.internal.process.MBeanInvocationFailedException;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessController;
import org.apache.geode.internal.process.ProcessControllerFactory;
import org.apache.geode.internal.process.ProcessControllerParameters;
import org.apache.geode.internal.process.ProcessLauncherContext;
import org.apache.geode.internal.process.ProcessType;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.process.UnableToControlProcessException;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.serialization.filter.SerializableObjectConfig;
import org.apache.geode.internal.serialization.filter.SystemPropertyGlobalSerialFilterConfigurationFactory;
import org.apache.geode.internal.serialization.filter.UnableToSetSerialFilterException;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.lang.AttachAPINotFoundException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.util.HostUtils;
import org.apache.geode.management.internal.util.JsonUtil;
import org.apache.logging.log4j.Logger;

public class LocatorLauncher
extends AbstractLauncher<String> {
    private static final Logger log = LogService.getLogger();
    @Immutable
    private static final Boolean DEFAULT_LOAD_SHARED_CONFIG_FROM_DIR = Boolean.FALSE;
    @Immutable
    private static final Map<String, String> helpMap;
    @Immutable
    private static final Map<Command, String> usageMap;
    private static final String DEFAULT_LOCATOR_LOG_EXT = ".log";
    private static final String DEFAULT_LOCATOR_LOG_NAME = "locator";
    private static final String LOCATOR_SERVICE_NAME = "Locator";
    @MakeNotStatic
    private static final AtomicReference<LocatorLauncher> INSTANCE;
    private final transient ControlNotificationHandler controlHandler;
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private final boolean deletePidFileOnStop;
    private final boolean force;
    private final boolean help;
    private final boolean redirectOutput;
    private final Command command;
    private final boolean bindAddressSpecified;
    private final boolean portSpecified;
    private final boolean workingDirectorySpecified;
    private final HostAddress bindAddress;
    private final Integer pid;
    private final Integer port;
    private volatile transient InternalLocator locator;
    private final Properties distributedSystemProperties;
    private final String hostnameForClients;
    private final String memberName;
    private final String workingDirectory;
    private volatile transient String statusMessage;
    private volatile transient ControllableProcess process;
    private final transient LocatorControllerParameters controllerParameters;

    public static void main(String ... args) {
        try {
            new Builder(args).build().run();
        }
        catch (AttachAPINotFoundException handled) {
            System.err.println(handled.getMessage());
        }
    }

    private static Integer getDefaultLocatorPort() {
        return Integer.getInteger("gemfire.test.DistributionLocator.OVERRIDE_DEFAULT_PORT", 10334);
    }

    public static LocatorLauncher getInstance() {
        return INSTANCE.get();
    }

    public static LocatorState getLocatorState() {
        return LocatorLauncher.getInstance() != null ? LocatorLauncher.getInstance().status() : null;
    }

    private LocatorLauncher(Builder builder) {
        this.command = builder.getCommand();
        this.help = Boolean.TRUE.equals(builder.getHelp());
        this.bindAddressSpecified = builder.isBindAddressSpecified();
        this.bindAddress = builder.getHostAddress();
        this.setDebug(Boolean.TRUE.equals(builder.getDebug()));
        this.deletePidFileOnStop = Boolean.TRUE.equals(builder.getDeletePidFileOnStop());
        this.distributedSystemProperties = builder.getDistributedSystemProperties();
        this.force = Boolean.TRUE.equals(builder.getForce());
        this.hostnameForClients = builder.getHostnameForClients();
        this.memberName = builder.getMemberName();
        this.pid = builder.getPid();
        this.portSpecified = builder.isPortSpecified();
        this.port = builder.getPort();
        this.redirectOutput = Boolean.TRUE.equals(builder.getRedirectOutput());
        this.workingDirectorySpecified = builder.isWorkingDirectorySpecified();
        this.workingDirectory = builder.getWorkingDirectory();
        this.controllerParameters = new LocatorControllerParameters();
        this.controlHandler = new ControlNotificationHandler(){

            @Override
            public void handleStop() {
                if (LocatorLauncher.this.isStoppable()) {
                    LocatorLauncher.this.stopInProcess();
                }
            }

            @Override
            public AbstractLauncher.ServiceState<?> handleStatus() {
                return LocatorLauncher.this.statusInProcess();
            }
        };
    }

    @Deprecated
    public static LocatorStatusResponse statusLocator(int port, InetAddress bindAddress) throws IOException {
        return LocatorLauncher.statusLocator(port, bindAddress == null ? null : bindAddress.getCanonicalHostName(), new DistributionConfigImpl(new Properties()));
    }

    public LocatorStatusResponse statusForLocator(int port, InetAddress bindAddressArg) throws IOException {
        String bindAddress = bindAddressArg == null ? null : bindAddressArg.getCanonicalHostName();
        SSLConfig sslConfig = this.getSSLConfigurations(this.getLocator());
        return LocatorLauncher.getLocatorStatusResponse(port, bindAddress, sslConfig);
    }

    private SSLConfig getSSLConfigurations(Locator locator) {
        SSLConfig sslConfig = locator == null ? SSLConfigurationFactory.getSSLConfigForComponent(this.getProperties(), SecurableCommunicationChannel.LOCATOR) : SSLConfigurationFactory.getSSLConfigForComponent(((InternalLocator)locator).getConfig(), SecurableCommunicationChannel.LOCATOR);
        return sslConfig;
    }

    public LocatorStatusResponse statusForLocator(int port, String hostname) throws IOException {
        SSLConfig sslConfig = this.getSSLConfigurations(this.getLocator());
        return LocatorLauncher.getLocatorStatusResponse(port, hostname, sslConfig);
    }

    private static LocatorStatusResponse statusLocator(int port, String bindAddress, DistributionConfigImpl distributionConfig) throws IOException {
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(distributionConfig, SecurableCommunicationChannel.LOCATOR);
        return LocatorLauncher.getLocatorStatusResponse(port, bindAddress, sslConfig);
    }

    private static LocatorStatusResponse getLocatorStatusResponse(int port, String bindAddress, SSLConfig sslConfig) throws IOException {
        int timeout = Integer.MAX_VALUE;
        try {
            SocketCreator socketCreator = new SocketCreator(sslConfig);
            TcpClient client = new TcpClient((TcpSocketCreator)socketCreator, InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), TcpSocketFactory.DEFAULT);
            return (LocatorStatusResponse)client.requestToServer(new HostAndPort(bindAddress == null ? HostUtils.getLocalHost() : bindAddress, port), (Object)new LocatorStatusRequest(), Integer.MAX_VALUE, true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Cache getCache() {
        return this.getInternalLocator().getCache();
    }

    public Locator getLocator() {
        return this.locator;
    }

    InternalLocator getInternalLocator() {
        return this.locator;
    }

    public String getId() {
        return LocatorState.getBindAddressAsString(this).concat("[").concat(LocatorState.getPortAsString(this)).concat("]");
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isForcing() {
        return this.force;
    }

    public boolean isHelping() {
        return this.help;
    }

    public boolean isRedirectingOutput() {
        return this.redirectOutput;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress == null ? null : this.bindAddress.getAddress();
    }

    protected String getBindAddressAsString() {
        try {
            if (this.bindAddress != null) {
                return this.bindAddress.getHostName();
            }
            return LocalHostUtil.getCanonicalLocalHostName();
        }
        catch (UnknownHostException handled) {
            return "localhost/127.0.0.1";
        }
    }

    public String getHostnameForClients() {
        return this.hostnameForClients;
    }

    @Override
    public String getLogFileName() {
        return ((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.getMemberName(), (CharSequence)DEFAULT_LOCATOR_LOG_NAME)).concat(DEFAULT_LOCATOR_LOG_EXT);
    }

    @Override
    public String getMemberName() {
        return (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.memberName, (CharSequence)super.getMemberName());
    }

    @Override
    public Integer getPid() {
        return this.pid;
    }

    public Integer getPort() {
        if (this.locator != null) {
            return this.locator.getPort();
        }
        return this.port;
    }

    public String getPortAsString() {
        Integer port = this.getPort();
        return (port != null ? port : LocatorLauncher.getDefaultLocatorPort()).toString();
    }

    public Properties getProperties() {
        return (Properties)this.distributedSystemProperties.clone();
    }

    @Override
    public String getServiceName() {
        return LOCATOR_SERVICE_NAME;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void help(Command command) {
        if (Command.isUnspecified(command)) {
            this.usage();
        } else {
            this.info(StringUtils.wrap(helpMap.get(command.getName()), 80, ""), new Object[0]);
            this.info("\n\nusage: \n\n", new Object[0]);
            this.info(StringUtils.wrap("> java ... " + this.getClass().getName() + " " + usageMap.get((Object)command), 80, "\t\t"), new Object[0]);
            this.info("\n\noptions: \n\n", new Object[0]);
            for (String option : command.getOptions()) {
                this.info(StringUtils.wrap("--" + option + ": " + helpMap.get(option) + "\n", 80, "\t"), new Object[0]);
            }
            this.info("\n\n", new Object[0]);
        }
    }

    public void usage() {
        this.info(StringUtils.wrap(helpMap.get("launcher"), 80, "\t"), new Object[0]);
        this.info("\n\nSTART\n\n", new Object[0]);
        this.help(Command.START);
        this.info("STATUS\n\n", new Object[0]);
        this.help(Command.STATUS);
        this.info("STOP\n\n", new Object[0]);
        this.help(Command.STOP);
    }

    @Override
    public void run() {
        if (!this.isHelping()) {
            switch (this.getCommand()) {
                case START: {
                    this.info(this.start(), new Object[0]);
                    this.waitOnLocator();
                    break;
                }
                case STATUS: {
                    this.info(this.status(), new Object[0]);
                    break;
                }
                case STOP: {
                    this.info(this.stop(), new Object[0]);
                    break;
                }
                case VERSION: {
                    this.info(this.version(), new Object[0]);
                    break;
                }
                default: {
                    this.usage();
                    break;
                }
            }
        } else {
            this.help(this.getCommand());
        }
    }

    protected File getLocatorPidFile() {
        return new File(this.getWorkingDirectory(), ProcessType.LOCATOR.getPidFileName());
    }

    private boolean isStartable() {
        return !this.isRunning() && this.starting.compareAndSet(false, true);
    }

    public LocatorState start() {
        if (this.isStartable()) {
            INSTANCE.compareAndSet(null, this);
            boolean serializationFilterConfigured = this.configureGlobalSerialFilterIfEnabled();
            try {
                this.process = new FileControllableProcess(this.controlHandler, new File(this.getWorkingDirectory()), ProcessType.LOCATOR, this.isForcing());
                LocatorLauncher.assertPortAvailable(this.getBindAddress(), this.getPort());
                ProcessLauncherContext.set(this.isRedirectingOutput(), this.getOverriddenDefaults(), statusMessage -> {
                    this.statusMessage = statusMessage;
                });
                try {
                    this.locator = InternalLocator.startLocator(this.getPort(), this.getLogFile(), null, null, this.bindAddress, true, this.getDistributedSystemProperties(), this.getHostnameForClients(), Paths.get(this.workingDirectory, new String[0]));
                    if (serializationFilterConfigured) {
                        log.info("Global serial filter is now configured.");
                    }
                }
                finally {
                    ProcessLauncherContext.remove();
                }
                this.debug("Running Locator on (%1$s) in (%2$s) as (%3$s)...", this.getId(), this.getWorkingDirectory(), this.getMember());
                log.debug("Locator is online");
                this.running.set(true);
                LocatorState locatorState = new LocatorState(this, AbstractLauncher.Status.ONLINE);
                return locatorState;
            }
            catch (IOException e) {
                this.failOnStart(e);
                throw new RuntimeException(String.format("An IO error occurred while starting a %s in %s on %s: %s", this.getServiceName(), this.getWorkingDirectory(), this.getId(), e.getMessage()), e);
            }
            catch (FileAlreadyExistsException e) {
                this.failOnStart(e);
                throw new RuntimeException(String.format("A PID file already exists and a %s may be running in %s on %s.", this.getServiceName(), this.getWorkingDirectory(), this.getId()), e);
            }
            catch (PidUnavailableException e) {
                this.failOnStart(e);
                throw new RuntimeException(String.format("The process ID could not be determined while starting %s %s in %s: %s", this.getServiceName(), this.getId(), this.getWorkingDirectory(), e.getMessage()), e);
            }
            catch (Error | RuntimeException e) {
                this.failOnStart(e);
                throw e;
            }
            catch (Exception e) {
                this.failOnStart(e);
                throw new RuntimeException(e);
            }
            finally {
                this.starting.set(false);
            }
        }
        throw new IllegalStateException(String.format("A %s is already running in %s on %s.", this.getServiceName(), this.getWorkingDirectory(), this.getId()));
    }

    private boolean configureGlobalSerialFilterIfEnabled() {
        try {
            return new SystemPropertyGlobalSerialFilterConfigurationFactory().create((SerializableObjectConfig)new DistributedSerializableObjectConfig(this.getDistributedSystemProperties())).configure();
        }
        catch (UnableToSetSerialFilterException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Properties getDistributedSystemProperties() {
        return super.getDistributedSystemProperties(this.getProperties());
    }

    private void failOnStart(Throwable cause) {
        if (cause != null) {
            log.info("locator is exiting due to an exception", cause);
        } else {
            log.info("locator is exiting normally");
        }
        if (this.locator != null) {
            this.locator.stop();
            this.locator = null;
        }
        if (this.process != null) {
            this.process.stop(this.deletePidFileOnStop);
            this.process = null;
        }
        INSTANCE.compareAndSet(this, null);
        this.running.set(false);
    }

    public LocatorState waitOnLocator() {
        Throwable t = null;
        try {
            assert (this.getInternalLocator() != null) : "The Locator must first be started with a call to start!";
            this.debug("Waiting on Locator (%1$s) to stop...", this.getId());
            this.getInternalLocator().waitToStop();
        }
        catch (InterruptedException handled) {
            Thread.currentThread().interrupt();
            t = handled;
            this.debug(handled);
        }
        catch (Throwable e) {
            t = e;
            throw e;
        }
        finally {
            this.failOnStart(t);
        }
        return new LocatorState(this, AbstractLauncher.Status.STOPPED);
    }

    public LocatorState waitOnStatusResponse(long timeout, long interval, TimeUnit timeUnit) {
        long endTimeInMilliseconds = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (System.currentTimeMillis() < endTimeInMilliseconds) {
            try {
                LocatorStatusResponse response = this.statusForLocator((int)this.getPort(), this.getBindAddressString());
                return new LocatorState(this, AbstractLauncher.Status.ONLINE, response);
            }
            catch (Exception handled) {
                this.timedWait(interval, timeUnit);
            }
        }
        return new LocatorState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timedWait(long interval, TimeUnit timeUnit) {
        try {
            LocatorLauncher locatorLauncher = this;
            synchronized (locatorLauncher) {
                timeUnit.timedWait(this, interval);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public LocatorState status() {
        LocatorLauncher launcher = LocatorLauncher.getInstance();
        if (this.starting.get()) {
            this.debug("Getting status from the LocatorLauncher instance that actually launched the Geode Locator.%n", new Object[0]);
            return new LocatorState(this, AbstractLauncher.Status.STARTING);
        }
        if (this.isRunning()) {
            this.debug("Getting Locator status using host (%1$s) and port (%2$s)%n", this.getBindAddressAsString(), this.getPortAsString());
            return this.statusWithPort();
        }
        if (this.isPidInProcess() && launcher != null) {
            return launcher.statusInProcess();
        }
        if (this.getPid() != null) {
            this.debug("Getting Locator status using process ID (%1$s)%n", this.getPid());
            return this.statusWithPid();
        }
        if (!this.bindAddressSpecified && !this.portSpecified) {
            this.debug("Getting Locator status using working directory (%1$s)%n", this.getWorkingDirectory());
            return this.statusWithWorkingDirectory();
        }
        this.debug("Getting Locator status using host (%1$s) and port (%2$s)%n", this.getBindAddressAsString(), this.getPortAsString());
        return this.statusWithPort();
    }

    private LocatorState statusInProcess() {
        if (this.starting.get()) {
            this.debug("Getting status from the LocatorLauncher instance that actually launched the Geode Locator.%n", new Object[0]);
            return new LocatorState(this, AbstractLauncher.Status.STARTING);
        }
        this.debug("Getting Locator status using host (%1$s) and port (%2$s)%n", this.getBindAddressAsString(), this.getPortAsString());
        return this.statusWithPort();
    }

    private LocatorState statusWithPid() {
        try {
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, this.getPid());
            controller.checkPidSupport();
            String statusJson = controller.status();
            return LocatorState.fromJson(statusJson);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to locator with process id " + this.getPid());
        }
        catch (IOException | TimeoutException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with locator with process id " + this.getPid());
        }
        catch (InterruptedException handled) {
            Thread.currentThread().interrupt();
            return this.createNoResponseState(handled, "Interrupted while trying to communicate with locator with process id " + this.getPid());
        }
    }

    private LocatorState statusWithPort() {
        try {
            LocatorStatusResponse response = this.statusForLocator((int)this.getPort(), this.getBindAddressString());
            return new LocatorState(this, AbstractLauncher.Status.ONLINE, response);
        }
        catch (Exception handled) {
            return this.createNoResponseState(handled, "Failed to connect to locator " + this.getBindAddressAsString() + "[" + this.getPort() + "]");
        }
    }

    private LocatorState statusWithWorkingDirectory() {
        int parsedPid = 0;
        try {
            LocatorLauncher runningLauncher;
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, new File(this.getWorkingDirectory()), ProcessType.LOCATOR.getPidFileName());
            parsedPid = controller.getProcessId();
            if (parsedPid == ProcessUtils.identifyPid() && (runningLauncher = LocatorLauncher.getInstance()) != null) {
                return runningLauncher.status();
            }
            String statusJson = controller.status();
            return LocatorState.fromJson(statusJson);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to locator with process id " + parsedPid);
        }
        catch (FileNotFoundException handled) {
            return this.createNoResponseState(handled, "Failed to find process file " + ProcessType.LOCATOR.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (IOException | TimeoutException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with locator with process id " + parsedPid);
        }
        catch (PidUnavailableException e) {
            return this.createNoResponseState(e, "Failed to find usable process id within file " + ProcessType.LOCATOR.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (InterruptedException handled) {
            Thread.currentThread().interrupt();
            return this.createNoResponseState(handled, "Interrupted while trying to communicate with locator with process id " + parsedPid);
        }
    }

    protected boolean isStoppable() {
        return this.isRunning() && this.getInternalLocator() != null;
    }

    public LocatorState stop() {
        LocatorLauncher launcher = LocatorLauncher.getInstance();
        if (this.isStoppable()) {
            return this.stopInProcess();
        }
        if (this.isPidInProcess() && launcher != null) {
            return launcher.stopInProcess();
        }
        if (this.getPid() != null) {
            return this.stopWithPid();
        }
        if (this.getWorkingDirectory() != null) {
            return this.stopWithWorkingDirectory();
        }
        return new LocatorState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private LocatorState stopInProcess() {
        if (this.isStoppable()) {
            this.locator.stop();
            this.locator = null;
            this.process.stop(this.deletePidFileOnStop);
            this.process = null;
            INSTANCE.compareAndSet(this, null);
            this.running.set(false);
            return new LocatorState(this, AbstractLauncher.Status.STOPPED);
        }
        return new LocatorState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private LocatorState stopWithPid() {
        try {
            ProcessController controller = new ProcessControllerFactory().createProcessController(new LocatorControllerParameters(), this.getPid());
            controller.checkPidSupport();
            controller.stop();
            return new LocatorState(this, AbstractLauncher.Status.STOPPED);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to locator with process id " + this.getPid());
        }
        catch (IOException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with locator with process id " + this.getPid());
        }
    }

    private LocatorState stopWithWorkingDirectory() {
        int parsedPid = 0;
        try {
            LocatorLauncher runningLauncher;
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, new File(this.getWorkingDirectory()), ProcessType.LOCATOR.getPidFileName());
            parsedPid = controller.getProcessId();
            if (parsedPid == ProcessUtils.identifyPid() && (runningLauncher = LocatorLauncher.getInstance()) != null) {
                return runningLauncher.stopInProcess();
            }
            controller.stop();
            return new LocatorState(this, AbstractLauncher.Status.STOPPED);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to locator with process id " + parsedPid);
        }
        catch (FileNotFoundException handled) {
            return this.createNoResponseState(handled, "Failed to find process file " + ProcessType.LOCATOR.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (IOException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with locator with process id " + parsedPid);
        }
        catch (InterruptedException handled) {
            Thread.currentThread().interrupt();
            return this.createNoResponseState(handled, "Interrupted while trying to communicate with locator with process id " + parsedPid);
        }
        catch (PidUnavailableException handled) {
            return this.createNoResponseState(handled, "Failed to find usable process id within file " + ProcessType.LOCATOR.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (TimeoutException handled) {
            return this.createNoResponseState(handled, "Timed out trying to find usable process id within file " + ProcessType.LOCATOR.getPidFileName() + " in " + this.getWorkingDirectory());
        }
    }

    private LocatorState createNoResponseState(Exception cause, String errorMessage) {
        this.debug(ExceptionUtils.getStackTrace((Throwable)cause) + errorMessage, new Object[0]);
        return new LocatorState(this, AbstractLauncher.Status.NOT_RESPONDING, errorMessage);
    }

    private Properties getOverriddenDefaults() throws IOException {
        Properties overriddenDefaults = new Properties();
        overriddenDefaults.put("gemfire.default.".concat("log-file"), this.getLogFile().getCanonicalPath());
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith("gemfire.default.")) continue;
            overriddenDefaults.put(key, System.getProperty(key));
        }
        return overriddenDefaults;
    }

    public String getBindAddressString() {
        return this.bindAddress == null ? null : this.bindAddress.getHostName();
    }

    static {
        HashMap<String, String> help = new HashMap<String, String>();
        help.put("launcher", "A Geode launcher used to start, stop and determine a Locator's status.");
        help.put(Command.START.getName(), String.format("Starts a Locator running in the current working directory listening on the default port (%s) bound to all IP addresses available to the localhost.  The Locator must be given a member name in the Geode cluster.  The default bind-address and port may be overridden using the corresponding command-line options.", LocatorLauncher.getDefaultLocatorPort()));
        help.put(Command.STATUS.getName(), "Displays the status of a Locator given any combination of the bind-address[port], member name/ID, PID, or the directory in which the Locator is running.");
        help.put(Command.STOP.getName(), "Stops a running Locator given a member name/ID, PID, or the directory in which the Locator is running.");
        help.put(Command.VERSION.getName(), "Displays Geode product version information.");
        help.put("bind-address", "Specifies the IP address on which to bind, or on which the Locator is bound, listening for client requests.  Defaults to all IP addresses available to the localhost.");
        help.put("debug", "Displays verbose information during the invocation of the launcher.");
        help.put("delete-pid-file-on-stop", "Specifies that this Locator's PID file should be deleted on stop.  The default is to not delete this Locator's PID file until JVM exit if --delete-pid-file-on-stop is not specified.");
        help.put("dir", "Specifies the working directory where the Locator is running.  Defaults to the current working directory.");
        help.put("force", "Enables any existing Locator PID file to be overwritten on start.  The default is to throw an error if a PID file already exists and --force is not specified.");
        help.put("help", "Causes Geode to print out information instead of performing the command. This option is supported by all commands.");
        help.put("hostname-for-clients", "An option to specify the hostname or IP address to send to clients so they can connect to this Locator. The default is to use the IP address to which the Locator is bound.");
        help.put("member", "Identifies the Locator by member name or ID in the Geode cluster.");
        help.put("pid", "Indicates the OS process ID of the running Locator.");
        help.put("port", String.format("Specifies the port on which the Locator is listening for client requests. Defaults to %s.", LocatorLauncher.getDefaultLocatorPort()));
        help.put("redirect-output", "An option to cause the Locator to redirect standard out and standard error to the Geode log file.");
        helpMap = Collections.unmodifiableMap(help);
        TreeMap<Command, String> usage = new TreeMap<Command, String>();
        usage.put(Command.START, "start <member-name> [--bind-address=<IP-address>] [--hostname-for-clients=<IP-address>] [--port=<port>] [--dir=<Locator-working-directory>] [--force] [--debug] [--help]");
        usage.put(Command.STATUS, "status [--bind-address=<IP-address>] [--port=<port>] [--member=<member-ID/Name>] [--pid=<process-ID>] [--dir=<Locator-working-directory>] [--debug] [--help]");
        usage.put(Command.STOP, "stop [--member=<member-ID/Name>] [--pid=<process-ID>] [--dir=<Locator-working-directory>] [--debug] [--help]");
        usage.put(Command.VERSION, "version");
        usageMap = usage;
        INSTANCE = new AtomicReference();
    }

    public static class LocatorState
    extends AbstractLauncher.ServiceState<String> {
        public static LocatorState fromJson(String json) {
            try {
                JsonNode jsonObject = new ObjectMapper().readTree(json);
                AbstractLauncher.Status status = AbstractLauncher.Status.valueOfDescription(jsonObject.get("status").asText());
                List<String> jvmArguments = JsonUtil.toStringList(jsonObject.get("jvmArguments"));
                return new LocatorState(status, jsonObject.get("statusMessage").asText(), jsonObject.get("timestamp").asLong(), jsonObject.get("location").asText(), jsonObject.get("pid").asInt(), jsonObject.get("uptime").asLong(), jsonObject.get("workingDirectory").asText(), jvmArguments, jsonObject.get("classpath").asText(), jsonObject.get("gemFireVersion").asText(), jsonObject.get("javaVersion").asText(), jsonObject.get("logFileName").asText(), jsonObject.get("bindAddress").asText(), jsonObject.get("port").asText(), jsonObject.get("memberName").asText());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create LocatorStatus from JSON: ".concat(json), e);
            }
        }

        public static LocatorState fromDirectory(String workingDirectory, String memberName) {
            LocatorState locatorState = new Builder().setWorkingDirectory(workingDirectory).build().status();
            if (ObjectUtils.equals(locatorState.getMemberName(), memberName)) {
                return locatorState;
            }
            return new LocatorState(new Builder().build(), AbstractLauncher.Status.NOT_RESPONDING);
        }

        public LocatorState(LocatorLauncher launcher, AbstractLauncher.Status status) {
            this(status, launcher.statusMessage, System.currentTimeMillis(), launcher.getId(), LocatorState.identifyPid(), ManagementFactory.getRuntimeMXBean().getUptime(), launcher.getWorkingDirectory(), ManagementFactory.getRuntimeMXBean().getInputArguments(), System.getProperty("java.class.path"), GemFireVersion.getGemFireVersion(), System.getProperty("java.version"), LocatorState.getLogFileCanonicalPath(launcher), launcher.getBindAddressAsString(), launcher.getPortAsString(), launcher.getMemberName());
        }

        public LocatorState(LocatorLauncher launcher, AbstractLauncher.Status status, String errorMessage) {
            this(status, errorMessage, System.currentTimeMillis(), LocatorState.getLocatorLocation(launcher), null, 0L, launcher.getWorkingDirectory(), ManagementFactory.getRuntimeMXBean().getInputArguments(), null, GemFireVersion.getGemFireVersion(), System.getProperty("java.version"), null, launcher.getBindAddressAsString(), launcher.getPortAsString(), null);
        }

        private static String getLocatorLocation(LocatorLauncher launcher) {
            if (launcher.getPort() == null) {
                return launcher.getId();
            }
            if (launcher.getBindAddress() == null) {
                return HostUtils.getLocatorId(HostUtils.getLocalHost(), launcher.getPort());
            }
            return HostUtils.getLocatorId(launcher.getBindAddressAsString(), launcher.getPort());
        }

        private static String getBindAddressAsString(LocatorLauncher launcher) {
            InternalLocator locator;
            String bindAddress;
            if (InternalLocator.hasLocator() && (bindAddress = (locator = InternalLocator.getLocator()).getBindAddressString()) != null && !bindAddress.isEmpty()) {
                return bindAddress;
            }
            return launcher.getBindAddressAsString();
        }

        private static String getLogFileCanonicalPath(LocatorLauncher launcher) {
            String logFileCanonicalPath;
            InternalLocator locator;
            File logFile;
            if (InternalLocator.hasLocator() && (logFile = (locator = InternalLocator.getLocator()).getLogFile()) != null && logFile.isFile() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(logFileCanonicalPath = IOUtils.tryGetCanonicalPathElseGetAbsolutePath(logFile)))) {
                return logFileCanonicalPath;
            }
            return launcher.getLogFileCanonicalPath();
        }

        private static String getPortAsString(LocatorLauncher launcher) {
            InternalLocator locator;
            String portAsString;
            if (InternalLocator.hasLocator() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(portAsString = String.valueOf((locator = InternalLocator.getLocator()).getPort())))) {
                return portAsString;
            }
            return launcher.getPortAsString();
        }

        protected LocatorState(AbstractLauncher.Status status, String statusMessage, long timestamp, String locatorLocation, Integer pid, Long uptime, String workingDirectory, List<String> jvmArguments, String classpath, String gemfireVersion, String javaVersion, String logFile, String host, String port, String memberName) {
            super(status, statusMessage, timestamp, locatorLocation, pid, uptime, workingDirectory, jvmArguments, classpath, gemfireVersion, javaVersion, logFile, host, port, memberName);
        }

        private LocatorState(LocatorLauncher launcher, AbstractLauncher.Status status, LocatorStatusResponse response) {
            this(status, launcher.statusMessage, System.currentTimeMillis(), launcher.getId(), response.getPid(), response.getUptime(), response.getWorkingDirectory(), response.getJvmArgs(), response.getClasspath(), response.getGemFireVersion(), response.getJavaVersion(), response.getLogFile(), response.getHost(), String.valueOf(response.getPort()), response.getName());
        }

        @Override
        protected String getServiceName() {
            return LocatorLauncher.LOCATOR_SERVICE_NAME;
        }
    }

    public static final class Command
    extends Enum<Command> {
        public static final /* enum */ Command START = new Command("start", "bind-address", "hostname-for-clients", "port", "force", "debug", "help");
        public static final /* enum */ Command STATUS = new Command("status", "bind-address", "port", "member", "pid", "dir", "debug", "help");
        public static final /* enum */ Command STOP = new Command("stop", "member", "pid", "dir", "debug", "help");
        public static final /* enum */ Command VERSION = new Command("version", new String[0]);
        public static final /* enum */ Command UNSPECIFIED = new Command("unspecified", new String[0]);
        private final List<String> options;
        private final String name;
        private static final /* synthetic */ Command[] $VALUES;

        public static Command[] values() {
            return (Command[])$VALUES.clone();
        }

        public static Command valueOf(String name) {
            return Enum.valueOf(Command.class, name);
        }

        private Command(String name, String ... options) {
            assert (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) : "The name of the locator launcher command must be specified!";
            this.name = name;
            this.options = options != null ? Collections.unmodifiableList(Arrays.asList(options)) : Collections.emptyList();
        }

        public static boolean isCommand(String name) {
            return Command.valueOfName(name) != null;
        }

        public static boolean isUnspecified(Command command) {
            return command == null || command.isUnspecified();
        }

        public static Command valueOfName(String name) {
            for (Command command : Command.values()) {
                if (!command.getName().equalsIgnoreCase(name)) continue;
                return command;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public boolean hasOption(String option) {
            return this.getOptions().contains(org.apache.commons.lang3.StringUtils.lowerCase((String)option));
        }

        public boolean isUnspecified() {
            return UNSPECIFIED == this;
        }

        public String toString() {
            return this.getName();
        }

        static {
            $VALUES = new Command[]{START, STATUS, STOP, VERSION, UNSPECIFIED};
        }
    }

    public static class Builder {
        @Immutable
        protected static final Command DEFAULT_COMMAND = Command.UNSPECIFIED;
        private Boolean debug;
        private Boolean deletePidFileOnStop;
        private Boolean force;
        private Boolean help;
        private Boolean redirectOutput;
        private Boolean loadSharedConfigFromDir;
        private Command command;
        private HostAddress bindAddress;
        private Integer pid;
        private Integer port;
        private final Properties distributedSystemProperties = new Properties();
        private String hostnameForClients;
        private String memberName;
        private String workingDirectory;

        public Builder() {
        }

        public Builder(String ... args) {
            this.parseArguments(args != null ? args : new String[]{});
        }

        private OptionParser getParser() {
            OptionParser parser = new OptionParser(true);
            parser.accepts("bind-address").withRequiredArg().ofType(String.class);
            parser.accepts("debug");
            parser.accepts("delete-pid-file-on-stop");
            parser.accepts("dir").withRequiredArg().ofType(String.class);
            parser.accepts("force");
            parser.accepts("help");
            parser.accepts("hostname-for-clients").withRequiredArg().ofType(String.class);
            parser.accepts("pid").withRequiredArg().ofType(Integer.class);
            parser.accepts("port").withRequiredArg().ofType(Integer.class);
            parser.accepts("redirect-output");
            parser.accepts("version");
            return parser;
        }

        protected void parseArguments(String ... args) {
            try {
                this.parseCommand(args);
                this.parseMemberName(args);
                OptionSet options = this.getParser().parse(args);
                this.setDebug(options.has("debug"));
                this.setDeletePidFileOnStop(options.has("delete-pid-file-on-stop"));
                this.setForce(options.has("force"));
                this.setHelp(options.has("help"));
                this.setRedirectOutput(options.has("redirect-output"));
                if (!this.isHelping()) {
                    if (options.has("bind-address")) {
                        this.setBindAddress(ObjectUtils.toString(options.valueOf("bind-address")));
                    }
                    if (options.has("dir")) {
                        this.setWorkingDirectory(ObjectUtils.toString(options.valueOf("dir")));
                    }
                    if (options.has("hostname-for-clients")) {
                        this.setHostnameForClients(ObjectUtils.toString(options.valueOf("hostname-for-clients")));
                    }
                    if (options.has("pid")) {
                        this.setPid((Integer)options.valueOf("pid"));
                    }
                    if (options.has("port")) {
                        this.setPort((Integer)options.valueOf("port"));
                    }
                    if (options.has("version")) {
                        this.setCommand(Command.VERSION);
                    }
                }
            }
            catch (OptionException e) {
                throw new IllegalArgumentException(String.format("An error occurred while parsing command-line arguments for the %s: %s", LocatorLauncher.LOCATOR_SERVICE_NAME, e.getMessage()), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        protected void parseCommand(String ... args) {
            if (args != null) {
                for (String arg : args) {
                    Command command = Command.valueOfName(arg);
                    if (command == null) continue;
                    this.setCommand(command);
                    break;
                }
            }
        }

        protected void parseMemberName(String ... args) {
            if (args != null) {
                for (String arg : args) {
                    if (arg.startsWith("-") || Command.isCommand(arg)) continue;
                    this.setMemberName(arg);
                    break;
                }
            }
        }

        public Command getCommand() {
            return this.command != null ? this.command : DEFAULT_COMMAND;
        }

        public Builder setCommand(Command command) {
            this.command = command;
            return this;
        }

        public Boolean getDebug() {
            return this.debug;
        }

        public Builder setDebug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Boolean getDeletePidFileOnStop() {
            return this.deletePidFileOnStop;
        }

        public Builder setDeletePidFileOnStop(Boolean deletePidFileOnStop) {
            this.deletePidFileOnStop = deletePidFileOnStop;
            return this;
        }

        public Properties getDistributedSystemProperties() {
            return this.distributedSystemProperties;
        }

        public Boolean getForce() {
            return this.force != null ? this.force : AbstractLauncher.DEFAULT_FORCE;
        }

        public Builder setForce(Boolean force) {
            this.force = force;
            return this;
        }

        public Boolean getHelp() {
            return this.help;
        }

        private boolean isHelping() {
            return Boolean.TRUE.equals(this.getHelp());
        }

        public Builder setHelp(Boolean help) {
            this.help = help;
            return this;
        }

        boolean isBindAddressSpecified() {
            return this.getBindAddress() != null;
        }

        public InetAddress getBindAddress() {
            return this.bindAddress == null ? null : this.bindAddress.getAddress();
        }

        HostAddress getHostAddress() {
            return this.bindAddress;
        }

        public Builder setBindAddress(String addressString) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)addressString)) {
                this.bindAddress = null;
                return this;
            }
            try {
                InetAddress address = InetAddress.getByName(addressString);
                if (LocalHostUtil.isLocalHost((Object)address)) {
                    this.bindAddress = new HostAddress(addressString);
                    return this;
                }
                throw new IllegalArgumentException(addressString + " is not an address for this machine.");
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("The hostname/IP address (" + addressString + ") to which the Locator will be bound is unknown.", e);
            }
        }

        public String getHostnameForClients() {
            return this.hostnameForClients;
        }

        public Builder setHostnameForClients(String hostnameForClients) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hostnameForClients)) {
                throw new IllegalArgumentException("The hostname used by clients to connect to the Locator must have an argument if the --hostname-for-clients command-line option is specified!");
            }
            this.hostnameForClients = hostnameForClients;
            return this;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public Builder setMemberName(String memberName) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)memberName)) {
                throw new IllegalArgumentException(String.format("The %s member name must be specified.", LocatorLauncher.LOCATOR_SERVICE_NAME));
            }
            this.memberName = memberName;
            return this;
        }

        public Integer getPid() {
            return this.pid;
        }

        public Builder setPid(Integer pid) {
            if (pid != null && pid < 0) {
                throw new IllegalArgumentException("A process ID (PID) must be a non-negative integer value.");
            }
            this.pid = pid;
            return this;
        }

        boolean isPortSpecified() {
            return this.port != null;
        }

        public Integer getPort() {
            return this.port != null ? this.port : LocatorLauncher.getDefaultLocatorPort();
        }

        public Builder setPort(Integer port) {
            if (port != null && (port < 0 || port > 65535)) {
                throw new IllegalArgumentException(String.format("The port on which the %s will listen must be between 1 and 65535 inclusive.", LocatorLauncher.LOCATOR_SERVICE_NAME));
            }
            this.port = port;
            return this;
        }

        public Boolean getRedirectOutput() {
            return this.redirectOutput;
        }

        private boolean isRedirectingOutput() {
            return Boolean.TRUE.equals(this.getRedirectOutput());
        }

        public Builder setRedirectOutput(Boolean redirectOutput) {
            this.redirectOutput = redirectOutput;
            return this;
        }

        boolean isWorkingDirectorySpecified() {
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.workingDirectory);
        }

        public String getWorkingDirectory() {
            return IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.workingDirectory, (CharSequence)AbstractLauncher.DEFAULT_WORKING_DIRECTORY)));
        }

        public Builder setWorkingDirectory(String workingDirectory) {
            if (!new File((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)workingDirectory, (CharSequence)AbstractLauncher.DEFAULT_WORKING_DIRECTORY)).isDirectory()) {
                throw new IllegalArgumentException(String.format("The working directory for the %s could not be found.", LocatorLauncher.LOCATOR_SERVICE_NAME), new FileNotFoundException(workingDirectory));
            }
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder set(String propertyName, String propertyValue) {
            this.distributedSystemProperties.setProperty(propertyName, propertyValue);
            return this;
        }

        public Builder set(Properties properties) {
            this.distributedSystemProperties.putAll((Map<?, ?>)properties);
            return this;
        }

        protected void validate() {
            if (!this.isHelping()) {
                this.validateOnStart();
                this.validateOnStatus();
                this.validateOnStop();
            }
        }

        protected void validateOnStart() {
            if (Command.START == this.getCommand()) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.getMemberName()) && !AbstractLauncher.isSet(System.getProperties(), "gemfire.name") && !AbstractLauncher.isSet(this.getDistributedSystemProperties(), "name") && !AbstractLauncher.isSet(AbstractLauncher.loadGemFireProperties(DistributedSystem.getPropertyFileURL()), "name")) {
                    throw new IllegalStateException(String.format("The member name of the %s must be provided as an argument to the launcher, or a path to gemfire.properties must be specified, which assumes the %s member name will be set using the name property.", LocatorLauncher.LOCATOR_SERVICE_NAME, LocatorLauncher.LOCATOR_SERVICE_NAME));
                }
                if (!SystemUtils.CURRENT_DIRECTORY.equalsIgnoreCase(this.getWorkingDirectory())) {
                    throw new IllegalStateException(String.format("Specifying the --dir option is not valid when starting a %s with the %sLauncher.", LocatorLauncher.LOCATOR_SERVICE_NAME, LocatorLauncher.LOCATOR_SERVICE_NAME));
                }
            }
        }

        protected void validateOnStatus() {
            if (Command.STATUS == this.getCommand()) {
                // empty if block
            }
        }

        protected void validateOnStop() {
            if (Command.STOP == this.getCommand()) {
                // empty if block
            }
        }

        public LocatorLauncher build() {
            this.validate();
            return new LocatorLauncher(this);
        }
    }

    private class LocatorControllerParameters
    implements ProcessControllerParameters {
        private LocatorControllerParameters() {
        }

        @Override
        public File getPidFile() {
            return LocatorLauncher.this.getLocatorPidFile();
        }

        @Override
        public File getDirectory() {
            return new File(LocatorLauncher.this.getWorkingDirectory());
        }

        @Override
        public int getProcessId() {
            return LocatorLauncher.this.getPid();
        }

        @Override
        public ProcessType getProcessType() {
            return ProcessType.LOCATOR;
        }

        @Override
        public ObjectName getNamePattern() {
            try {
                return ObjectName.getInstance("GemFire:type=Member,*");
            }
            catch (NullPointerException | MalformedObjectNameException handled) {
                return null;
            }
        }

        @Override
        public String getPidAttribute() {
            return "ProcessId";
        }

        @Override
        public String getStopMethod() {
            return "shutDownMember";
        }

        @Override
        public String getStatusMethod() {
            return "status";
        }

        @Override
        public String[] getAttributes() {
            return new String[]{LocatorLauncher.LOCATOR_SERVICE_NAME, "Server"};
        }

        @Override
        public Object[] getValues() {
            return new Object[]{Boolean.TRUE, Boolean.FALSE};
        }
    }
}

