/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.processors;

import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.tvf.common.ClockService;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;

public abstract class WindowAggProcessorBase<W, C extends WindowProcessor.Context<W>>
implements WindowProcessor<W, C> {
    private static final long serialVersionUID = 1L;
    protected final GeneratedNamespaceAggsHandleFunction<W> genAggsHandler;
    protected final TypeSerializer<RowData> accSerializer;
    protected final boolean isEventTime;
    protected final ZoneId shiftTimeZone;
    protected final boolean useDayLightSaving;
    protected transient long currentProgress;
    protected transient C ctx;
    protected transient ClockService clockService;
    protected transient WindowTimerService<W> windowTimerService;
    protected transient NamespaceAggsHandleFunction<W> aggregator;
    protected transient JoinedRowData reuseOutput;

    public WindowAggProcessorBase(GeneratedNamespaceAggsHandleFunction<W> genAggsHandler, TypeSerializer<RowData> accSerializer, boolean isEventTime, ZoneId shiftTimeZone) {
        this.genAggsHandler = genAggsHandler;
        this.accSerializer = accSerializer;
        this.isEventTime = isEventTime;
        this.shiftTimeZone = shiftTimeZone;
        this.useDayLightSaving = TimeZone.getTimeZone(shiftTimeZone).useDaylightTime();
    }

    @Override
    public void open(C context) throws Exception {
        this.ctx = context;
        this.clockService = ClockService.of(this.ctx.getTimerService());
        this.aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(this.ctx.getRuntimeContext().getUserCodeClassLoader());
        this.reuseOutput = new JoinedRowData();
        this.currentProgress = Long.MIN_VALUE;
        this.windowTimerService = this.getWindowTimerService();
        this.prepareAggregator();
    }

    @Override
    public void initializeWatermark(long watermark) {
        if (this.isEventTime) {
            this.currentProgress = watermark;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.aggregator != null) {
            this.aggregator.close();
        }
    }

    protected abstract void prepareAggregator() throws Exception;

    protected abstract WindowTimerService<W> getWindowTimerService();

    protected void collect(RowData currentKey, RowData aggResult) {
        this.reuseOutput.replace(currentKey, aggResult);
        this.ctx.output((RowData)this.reuseOutput);
    }
}

