/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.hint.StateTtlHint;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMultiJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.JoinKeyExtractor;
import scala.collection.immutable.List;

public class StreamPhysicalMultiJoin
extends AbstractRelNode
implements StreamPhysicalRel {
    private java.util.List<RelNode> inputs;
    private final RexNode joinFilter;
    private final java.util.List<JoinRelType> joinTypes;
    private final java.util.List<? extends @Nullable RexNode> joinConditions;
    private final JoinKeyExtractor keyExtractor;
    private final Map<Integer, java.util.List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap;
    private final @Nullable RexNode postJoinFilter;
    private final java.util.List<RelHint> hints;
    private @Nullable RexNode multiJoinCondition;
    private @Nullable java.util.List<java.util.List<int[]>> inputUniqueKeys;

    public StreamPhysicalMultiJoin(RelOptCluster cluster, RelTraitSet traitSet, java.util.List<RelNode> inputs, RexNode joinFilter, RelDataType rowType, java.util.List<? extends @Nullable RexNode> joinConditions, java.util.List<JoinRelType> joinTypes, Map<Integer, java.util.List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap, @Nullable RexNode postJoinFilter, java.util.List<RelHint> hints, JoinKeyExtractor keyExtractor) {
        super(cluster, traitSet);
        this.inputs = inputs;
        this.rowType = rowType;
        this.joinFilter = joinFilter;
        this.joinTypes = joinTypes;
        this.joinConditions = joinConditions;
        this.joinAttributeMap = joinAttributeMap;
        this.postJoinFilter = postJoinFilter;
        this.hints = hints;
        this.keyExtractor = keyExtractor;
        this.multiJoinCondition = this.getMultiJoinCondition();
        this.inputUniqueKeys = this.getUniqueKeysForInputs();
    }

    @Override
    public boolean requireWatermark() {
        return false;
    }

    @Override
    public java.util.List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        assert (ordinalInParent >= 0 && ordinalInParent < this.inputs.size());
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(this.inputs);
        newInputs.set(ordinalInParent, p);
        this.inputs = java.util.List.copyOf(newInputs);
        this.multiJoinCondition = null;
        this.inputUniqueKeys = null;
        this.recomputeDigest();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        return new StreamPhysicalMultiJoin(this.getCluster(), traitSet, inputs, this.joinFilter, this.getRowType(), this.joinConditions, this.joinTypes, this.joinAttributeMap, this.postJoinFilter, this.hints, this.keyExtractor);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double elementRate = 100.0 * (double)this.getInputs().size();
        return planner.getCostFactory().makeCost(elementRate, elementRate, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<RelNode> ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("commonJoinKey", this.getCommonJoinKeyFieldNames()).item("joinTypes", this.formatJoinTypes()).item("inputUniqueKeys", this.formatInputUniqueKeysWithFieldNames()).itemIf("stateTtlHints", RelExplainUtil.hintsToString(this.hints), !this.hints.isEmpty()).item("joinConditions", this.formatJoinConditionsWithFieldNames(pw)).itemIf("postJoinFilter", this.formatExpressionWithFieldNames(this.postJoinFilter, pw), this.postJoinFilter != null).item("select", String.join((CharSequence)",", this.getRowType().getFieldNames())).item("rowType", this.getRowType());
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        RexNode multijoinCondition = this.getMultiJoinCondition();
        java.util.List<java.util.List<int[]>> localInputUniqueKeys = this.getUniqueKeysForInputs();
        java.util.List<FlinkJoinType> execJoinTypes = this.getExecJoinTypes();
        java.util.List<InputProperty> inputProperties = this.createInputProperties();
        return new StreamExecMultiJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), execJoinTypes, this.joinConditions, multijoinCondition, this.joinAttributeMap, localInputUniqueKeys, StateTtlHint.getStateTtlFromHintOnMultiRel(this.hints), inputProperties, FlinkTypeFactory.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    private RexNode createMultiJoinCondition() {
        ArrayList<RexNode> conjunctions = new ArrayList<RexNode>();
        for (RexNode rexNode : this.joinConditions) {
            if (rexNode == null) continue;
            conjunctions.add(rexNode);
        }
        conjunctions.add(this.joinFilter);
        if (this.postJoinFilter != null) {
            conjunctions.add(this.postJoinFilter);
        }
        return RexUtil.composeConjunction(this.getCluster().getRexBuilder(), conjunctions, true);
    }

    public java.util.List<java.util.List<int[]>> getUniqueKeysForInputs() {
        if (this.inputUniqueKeys == null) {
            this.inputUniqueKeys = this.inputs.stream().map(input -> {
                Set<ImmutableBitSet> uniqueKeys = this.getUniqueKeys((RelNode)input);
                if (uniqueKeys == null) {
                    return Collections.emptyList();
                }
                return uniqueKeys.stream().map(ImmutableBitSet::toArray).collect(Collectors.toList());
            }).collect(Collectors.toUnmodifiableList());
        }
        return this.inputUniqueKeys;
    }

    public int[] getJoinKeyIndices(int inputId) {
        return this.keyExtractor.getJoinKeyIndices(inputId);
    }

    private @Nullable Set<ImmutableBitSet> getUniqueKeys(RelNode input) {
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(input.getCluster().getMetadataQuery());
        return fmq.getUniqueKeys(input);
    }

    public RexNode getMultiJoinCondition() {
        if (this.multiJoinCondition == null) {
            this.multiJoinCondition = this.createMultiJoinCondition();
        }
        return this.multiJoinCondition;
    }

    private java.util.List<FlinkJoinType> getExecJoinTypes() {
        return this.joinTypes.stream().map(joinType -> {
            if (joinType == JoinRelType.INNER) {
                return FlinkJoinType.INNER;
            }
            if (joinType == JoinRelType.LEFT) {
                return FlinkJoinType.LEFT;
            }
            throw new UnsupportedOperationException("Unsupported join type: " + String.valueOf(joinType));
        }).collect(Collectors.toList());
    }

    public java.util.List<JoinRelType> getJoinTypes() {
        return this.joinTypes;
    }

    private String getCommonJoinKeyFieldNames() {
        int[] commonJoinKeyIndices = this.keyExtractor.getCommonJoinKeyIndices(0);
        RelNode firstInput = this.inputs.get(0);
        java.util.List<String> fieldNames = firstInput.getRowType().getFieldNames();
        ArrayList<String> commonJoinKey = new ArrayList<String>();
        for (int index : commonJoinKeyIndices) {
            if (index >= fieldNames.size()) continue;
            commonJoinKey.add(fieldNames.get(index));
        }
        if (commonJoinKey.isEmpty()) {
            return "noCommonJoinKey";
        }
        return String.join((CharSequence)", ", commonJoinKey);
    }

    private String formatExpressionWithFieldNames(RexNode expression, RelWriter pw) {
        if (expression == null) {
            return "";
        }
        return this.getExpressionString(expression, (List<String>)JavaScalaConversionUtil.toScala(this.getRowType().getFieldNames()).toList(), JavaScalaConversionUtil.toScala(Optional.empty()), RelExplainUtil.preferExpressionFormat(pw), RelExplainUtil.preferExpressionDetail(pw));
    }

    private String formatJoinConditionsWithFieldNames(RelWriter pw) {
        return this.joinConditions.stream().skip(1L).filter(Objects::nonNull).map(condition -> this.formatExpressionWithFieldNames((RexNode)condition, pw)).collect(Collectors.joining(", "));
    }

    private String formatJoinTypes() {
        return this.joinTypes.stream().skip(1L).map(Enum::toString).collect(Collectors.joining(", "));
    }

    private String formatInputUniqueKeysWithFieldNames() {
        ArrayList<String> inputUniqueKeyStrings = new ArrayList<String>();
        for (RelNode input : this.inputs) {
            Set<ImmutableBitSet> uniqueKeys = this.getUniqueKeys(input);
            if (uniqueKeys != null && !uniqueKeys.isEmpty()) {
                java.util.List<String> fieldNames = input.getRowType().getFieldNames();
                ArrayList<CallSite> uniqueKeyStrings = new ArrayList<CallSite>();
                for (ImmutableBitSet uniqueKey : uniqueKeys) {
                    ArrayList<String> keyFieldNames = new ArrayList<String>();
                    for (int index : uniqueKey.toArray()) {
                        if (index >= fieldNames.size()) continue;
                        keyFieldNames.add(fieldNames.get(index));
                    }
                    if (keyFieldNames.isEmpty()) continue;
                    uniqueKeyStrings.add((CallSite)((Object)("(" + String.join((CharSequence)", ", keyFieldNames) + ")")));
                }
                inputUniqueKeyStrings.add(String.join((CharSequence)", ", uniqueKeyStrings));
                continue;
            }
            inputUniqueKeyStrings.add("noUniqueKey");
        }
        return String.join((CharSequence)", ", inputUniqueKeyStrings);
    }

    public boolean inputUniqueKeyContainsCommonJoinKey(int inputId) {
        RelNode input = this.getInputs().get(inputId);
        Set<ImmutableBitSet> inputUniqueKeysSet = this.getUniqueKeys(input);
        if (inputUniqueKeysSet == null || inputUniqueKeysSet.isEmpty()) {
            return false;
        }
        int[] commonJoinKeyIndices = this.keyExtractor.getCommonJoinKeyIndices(inputId);
        if (commonJoinKeyIndices.length == 0) {
            return false;
        }
        ImmutableBitSet commonJoinKeys = ImmutableBitSet.of(commonJoinKeyIndices);
        return inputUniqueKeysSet.stream().anyMatch(uniqueKey -> uniqueKey.contains(commonJoinKeys));
    }

    private java.util.List<InputProperty> createInputProperties() {
        ArrayList<InputProperty> inputProperties = new ArrayList<InputProperty>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            InputProperty inputProperty = this.createInputPropertyFromTrait(this.getInput(i), i);
            inputProperties.add(inputProperty);
        }
        return inputProperties;
    }

    private InputProperty createInputPropertyFromTrait(RelNode input, int inputIndex) {
        InputProperty.RequiredDistribution requiredDistribution;
        FlinkRelDistribution distribution = input.getTraitSet().getTrait(FlinkRelDistributionTraitDef.INSTANCE());
        if (distribution == null) {
            return InputProperty.DEFAULT;
        }
        switch (distribution.getType()) {
            case HASH_DISTRIBUTED: {
                int[] keys = distribution.getKeys().toIntArray();
                if (keys.length == 0) {
                    requiredDistribution = InputProperty.SINGLETON_DISTRIBUTION;
                    break;
                }
                requiredDistribution = InputProperty.hashDistribution(keys);
                break;
            }
            case SINGLETON: {
                requiredDistribution = InputProperty.SINGLETON_DISTRIBUTION;
                break;
            }
            default: {
                return InputProperty.DEFAULT;
            }
        }
        return InputProperty.builder().requiredDistribution(requiredDistribution).damBehavior(InputProperty.DamBehavior.PIPELINED).priority(inputIndex).build();
    }
}

