/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.sql.parser.ddl.SqlAlterTableReset;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterTableChangeOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;

public class SqlAlterTableResetConverter
extends AbstractAlterTableConverter<SqlAlterTableReset> {
    @Override
    protected Operation convertToOperation(SqlAlterTableReset alterTableReset, ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        ObjectIdentifier tableIdentifier = this.getIdentifier(alterTableReset, context);
        HashMap newOptions = new HashMap(oldTable.getOptions());
        Set<String> resetKeys = alterTableReset.getResetKeys();
        if (resetKeys.isEmpty() || resetKeys.contains(FactoryUtil.CONNECTOR.key())) {
            String exMsg = resetKeys.isEmpty() ? "ALTER TABLE RESET does not support empty key" : "ALTER TABLE RESET does not support changing 'connector'";
            throw new ValidationException(exMsg);
        }
        resetKeys.forEach(newOptions::remove);
        return new AlterTableChangeOperation(tableIdentifier, resetKeys.stream().map(TableChange::reset).collect(Collectors.toList()), (CatalogTable)oldTable.copy(newOptions), alterTableReset.ifTableExists());
    }
}

