/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.ArrayList;
import org.apache.flink.sql.parser.ddl.SqlDropPartitions;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.DropPartitionsOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlAlterTableDropPartitionConverter
implements SqlNodeConverter<SqlDropPartitions> {
    @Override
    public Operation convertSqlNode(SqlDropPartitions sqlDropPartitions, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropPartitions.fullTableName());
        ObjectIdentifier tableIdentifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        ArrayList<CatalogPartitionSpec> specs = new ArrayList<CatalogPartitionSpec>();
        for (int i = 0; i < sqlDropPartitions.getPartSpecs().size(); ++i) {
            specs.add(new CatalogPartitionSpec(sqlDropPartitions.getPartitionKVs(i)));
        }
        return new DropPartitionsOperation(tableIdentifier, sqlDropPartitions.ifExists(), specs);
    }
}

