/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDistribution
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DISTRIBUTED BY", SqlKind.OTHER);
    private final String distributionKind;
    private final SqlNodeList bucketColumns;
    private final SqlNumericLiteral bucketCount;

    public SqlDistribution(SqlParserPos pos, @Nullable String distributionKind, @Nullable SqlNodeList bucketColumns, @Nullable SqlNumericLiteral bucketCount) {
        super(pos);
        this.distributionKind = distributionKind;
        this.bucketColumns = bucketColumns;
        this.bucketCount = bucketCount;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.bucketCount, this.bucketColumns);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.unparse(writer, leftPrec, rightPrec, "DISTRIBUTED");
    }

    public void unparseAlter(SqlWriter writer, int leftPrec, int rightPrec) {
        this.unparse(writer, leftPrec, rightPrec, "DISTRIBUTION");
    }

    private void unparse(SqlWriter writer, int leftPrec, int rightPrec, String keyword) {
        if (this.bucketColumns.isEmpty() && this.bucketCount != null) {
            writer.keyword(keyword + " INTO");
            this.bucketCount.unparse(writer, leftPrec, rightPrec);
            writer.keyword("BUCKETS");
            return;
        }
        writer.keyword(keyword + " BY");
        if (this.distributionKind != null) {
            writer.print(this.distributionKind);
        }
        SqlWriter.Frame bucketFrame = writer.startList("(", ")");
        this.bucketColumns.unparse(writer, leftPrec, rightPrec);
        writer.endList(bucketFrame);
        if (this.bucketCount != null) {
            writer.keyword("INTO");
            this.bucketCount.unparse(writer, leftPrec, rightPrec);
            writer.keyword("BUCKETS");
        }
    }

    public Optional<String> getDistributionKind() {
        return Optional.ofNullable(this.distributionKind);
    }

    public SqlNumericLiteral getBucketCount() {
        return this.bucketCount;
    }

    public SqlNodeList getBucketColumns() {
        return this.bucketColumns;
    }
}

