/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.misc.ServletSupport;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractOsgiManagerPlugin
extends AbstractServlet
implements OsgiManagerPlugin,
ServletSupport {
    public static final String ATTR_LABEL_MAP = "felix.webconsole.labelMap";
    public static final String ATTR_LABEL_MAP_CATEGORIZED = "felix.webconsole.labelMap.categorized";
    private final Map<String, ServiceTracker<?, ?>> services = new HashMap();
    protected volatile BundleContext bundleContext;
    protected volatile ServiceRegistration<Servlet> reg;

    protected abstract String getTitle();

    protected abstract String getLabel();

    protected String getCategory() {
        return null;
    }

    protected String[] getCssReferences() {
        return null;
    }

    @Override
    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("felix.webconsole.label", this.getLabel());
        ((Dictionary)props).put("felix.webconsole.title", this.getTitle());
        if (this.getCategory() != null) {
            ((Dictionary)props).put("felix.webconsole.category", this.getCategory());
        }
        if (this.getCssReferences() != null && this.getCssReferences().length > 0) {
            ((Dictionary)props).put("felix.webconsole.css", this.getCssReferences());
        }
        this.reg = this.bundleContext.registerService(Servlet.class, (Object)this, props);
    }

    @Override
    public void deactivate() {
        if (this.reg != null) {
            try {
                this.reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.reg = null;
        }
        for (ServiceTracker<?, ?> tracker : this.services.values()) {
            tracker.close();
        }
        this.services.clear();
        this.bundleContext = null;
    }

    @Override
    public synchronized Object getService(String serviceName) {
        ServiceTracker serviceTracker = this.services.get(serviceName);
        if (serviceTracker == null) {
            serviceTracker = new ServiceTracker(this.bundleContext, serviceName, new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    return AbstractOsgiManagerPlugin.this.bundleContext.getService(reference);
                }

                public void removedService(ServiceReference reference, Object service) {
                    try {
                        AbstractOsgiManagerPlugin.this.bundleContext.ungetService(reference);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }
            });
            serviceTracker.open();
            this.services.put(serviceName, serviceTracker);
        }
        return serviceTracker.getService();
    }

    protected int getParameterInt(HttpServletRequest request, String name, int defaultValue) {
        int ret = defaultValue;
        String param = request.getParameter(name);
        if (param != null) {
            try {
                ret = Integer.parseInt(param);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }
}

