/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUtil;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.Format;
import org.apache.datasketches.cpc.PreambleUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    static final short defaultSeedHash = Util.computeSeedHash((long)9001L);

    private static void checkFirst8(MemorySegment wseg, Format format, int lgK, int fiCol) {
        Assert.assertEquals((Object)PreambleUtil.getFormat((MemorySegment)wseg), (Object)format);
        Assert.assertEquals((int)PreambleUtil.getPreInts((MemorySegment)wseg), (int)PreambleUtil.getDefinedPreInts((Format)format));
        Assert.assertEquals((int)PreambleUtil.getSerVer((MemorySegment)wseg), (int)1);
        Assert.assertEquals((Object)PreambleUtil.getFamily((MemorySegment)wseg), (Object)Family.CPC);
        Assert.assertEquals((int)PreambleUtil.getLgK((MemorySegment)wseg), (int)lgK);
        Assert.assertEquals((int)PreambleUtil.getFiCol((MemorySegment)wseg), (int)fiCol);
        Assert.assertEquals((int)PreambleUtil.getFlags((MemorySegment)wseg), (int)(format.ordinal() << 2 | 2));
        Assert.assertEquals((short)PreambleUtil.getSeedHash((MemorySegment)wseg), (short)defaultSeedHash);
    }

    @Test
    public void checkNormalPutSegment() {
        int lgK = 12;
        double kxp = 12.0;
        double hipAccum = 1005.0;
        boolean fiCol = true;
        int[] csvStream = new int[]{1, 2, 3};
        int numCoupons = csvStream.length;
        int csvLength = csvStream.length;
        short seedHash = defaultSeedHash;
        int[] cwStream = new int[]{4, 5, 6};
        int cwLength = cwStream.length;
        int numSv = cwStream.length;
        int maxInts = 10 + csvLength + cwLength;
        MemorySegment wseg = MemorySegment.ofArray(new byte[4 * maxInts]);
        Format format = Format.EMPTY_MERGED;
        PreambleUtil.putEmptyMerged((MemorySegment)wseg, (int)12, (short)seedHash);
        PreambleUtilTest.println(CpcSketch.toString((byte[])wseg.toArray(ValueLayout.JAVA_BYTE), (boolean)true));
        PreambleUtilTest.checkFirst8(wseg, format, 12, 0);
        Assert.assertFalse((boolean)PreambleUtil.hasHip((MemorySegment)wseg));
        format = Format.SPARSE_HYBRID_MERGED;
        PreambleUtil.putSparseHybridMerged((MemorySegment)wseg, (int)12, (int)numCoupons, (int)csvLength, (short)seedHash, (int[])csvStream);
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)false));
        PreambleUtilTest.checkFirst8(wseg, format, 12, 0);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((MemorySegment)wseg), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((MemorySegment)wseg), (int)csvLength);
        format = Format.SPARSE_HYBRID_HIP;
        PreambleUtil.putSparseHybridHip((MemorySegment)wseg, (int)12, (int)numCoupons, (int)csvLength, (double)12.0, (double)1005.0, (short)seedHash, (int[])csvStream);
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)false));
        PreambleUtilTest.checkFirst8(wseg, format, 12, 0);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((MemorySegment)wseg), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((MemorySegment)wseg), (int)csvLength);
        Assert.assertEquals((double)PreambleUtil.getKxP((MemorySegment)wseg), (double)12.0);
        Assert.assertEquals((double)PreambleUtil.getHipAccum((MemorySegment)wseg), (double)1005.0);
        Assert.assertTrue((boolean)PreambleUtil.hasHip((MemorySegment)wseg));
        format = Format.PINNED_SLIDING_MERGED_NOSV;
        PreambleUtil.putPinnedSlidingMergedNoSv((MemorySegment)wseg, (int)12, (int)1, (int)numCoupons, (int)cwLength, (short)seedHash, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)false));
        PreambleUtilTest.checkFirst8(wseg, format, 12, 1);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((MemorySegment)wseg), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((MemorySegment)wseg), (int)cwLength);
        format = Format.PINNED_SLIDING_HIP_NOSV;
        PreambleUtil.putPinnedSlidingHipNoSv((MemorySegment)wseg, (int)12, (int)1, (int)numCoupons, (int)cwLength, (double)12.0, (double)1005.0, (short)seedHash, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)false));
        PreambleUtilTest.checkFirst8(wseg, format, 12, 1);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((MemorySegment)wseg), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((MemorySegment)wseg), (int)cwLength);
        Assert.assertEquals((double)PreambleUtil.getKxP((MemorySegment)wseg), (double)12.0);
        Assert.assertEquals((double)PreambleUtil.getHipAccum((MemorySegment)wseg), (double)1005.0);
        format = Format.PINNED_SLIDING_MERGED;
        PreambleUtil.putPinnedSlidingMerged((MemorySegment)wseg, (int)12, (int)1, (int)numCoupons, (int)numSv, (int)csvLength, (int)cwLength, (short)seedHash, (int[])csvStream, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)false));
        PreambleUtilTest.checkFirst8(wseg, format, 12, 1);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((MemorySegment)wseg), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getNumSv((MemorySegment)wseg), (int)numSv);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((MemorySegment)wseg), (int)csvLength);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((MemorySegment)wseg), (int)cwLength);
        format = Format.PINNED_SLIDING_HIP;
        PreambleUtil.putPinnedSlidingHip((MemorySegment)wseg, (int)12, (int)1, (int)numCoupons, (int)numSv, (double)12.0, (double)1005.0, (int)csvLength, (int)cwLength, (short)seedHash, (int[])csvStream, (int[])cwStream);
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)true));
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)false));
        PreambleUtilTest.checkFirst8(wseg, format, 12, 1);
        Assert.assertEquals((int)PreambleUtil.getNumCoupons((MemorySegment)wseg), (int)numCoupons);
        Assert.assertEquals((int)PreambleUtil.getNumSv((MemorySegment)wseg), (int)numSv);
        Assert.assertEquals((int)PreambleUtil.getSvLengthInts((MemorySegment)wseg), (int)csvLength);
        Assert.assertEquals((int)PreambleUtil.getWLengthInts((MemorySegment)wseg), (int)cwLength);
        Assert.assertEquals((double)PreambleUtil.getKxP((MemorySegment)wseg), (double)12.0);
        Assert.assertEquals((double)PreambleUtil.getHipAccum((MemorySegment)wseg), (double)1005.0);
    }

    @Test
    public void checkStreamErrors() {
        MemorySegment wseg = MemorySegment.ofArray(new byte[40]);
        PreambleUtil.putEmptyMerged((MemorySegment)wseg, (int)12, (short)defaultSeedHash);
        try {
            PreambleUtil.getSvStreamOffset((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        wseg.set(ValueLayout.JAVA_BYTE, 5L, (byte)28);
        try {
            PreambleUtil.getSvStreamOffset((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        wseg.set(ValueLayout.JAVA_BYTE, 5L, (byte)0);
        try {
            PreambleUtil.getWStreamOffset((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        wseg.set(ValueLayout.JAVA_BYTE, 5L, (byte)28);
        try {
            PreambleUtil.getWStreamOffset((MemorySegment)wseg);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkStreamErrors2() {
        MemorySegment wseg = MemorySegment.ofArray(new byte[40]);
        int[] svStream = new int[]{1};
        int[] wStream = new int[]{2};
        try {
            PreambleUtil.putPinnedSlidingMerged((MemorySegment)wseg, (int)4, (int)0, (int)1, (int)1, (int)1, (int)0, (short)0, (int[])svStream, (int[])wStream);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)PreambleUtil.isCompressed((MemorySegment)wseg));
    }

    @Test
    public void checkEmptySegment() {
        MemorySegment wseg = MemorySegment.ofArray(new byte[40]);
        wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)16);
        wseg.set(ValueLayout.JAVA_BYTE, 5L, (byte)4);
        PreambleUtilTest.println(CpcSketch.toString((MemorySegment)wseg, (boolean)false));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkFieldError() {
        PreambleUtil.fieldError((Format)Format.EMPTY_MERGED, (PreambleUtil.HiField)PreambleUtil.HiField.NUM_COUPONS);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCapacity() {
        PreambleUtil.checkCapacity((long)100L, (long)101L);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkHiFieldError() {
        PreambleUtil.getHiFieldOffset((Format)Format.EMPTY_MERGED, (PreambleUtil.HiField)PreambleUtil.HiField.NUM_COUPONS);
    }

    @Test
    public void checkWindowOffset() {
        long offset = CpcUtil.determineCorrectOffset((int)4, (long)54L);
        Assert.assertEquals((long)offset, (long)1L);
    }

    @Test
    public void checkFormatEnum() {
        Assert.assertEquals((Object)Format.EMPTY_MERGED, (Object)Format.ordinalToFormat((int)0));
        Assert.assertEquals((Object)Format.EMPTY_HIP, (Object)Format.ordinalToFormat((int)1));
        Assert.assertEquals((Object)Format.SPARSE_HYBRID_MERGED, (Object)Format.ordinalToFormat((int)2));
        Assert.assertEquals((Object)Format.SPARSE_HYBRID_HIP, (Object)Format.ordinalToFormat((int)3));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_MERGED_NOSV, (Object)Format.ordinalToFormat((int)4));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_HIP_NOSV, (Object)Format.ordinalToFormat((int)5));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_MERGED, (Object)Format.ordinalToFormat((int)6));
        Assert.assertEquals((Object)Format.PINNED_SLIDING_HIP, (Object)Format.ordinalToFormat((int)7));
    }

    @Test
    public void checkFlavorEnum() {
        Assert.assertEquals((Object)Flavor.EMPTY, (Object)Flavor.ordinalToFlavor((int)0));
        Assert.assertEquals((Object)Flavor.SPARSE, (Object)Flavor.ordinalToFlavor((int)1));
        Assert.assertEquals((Object)Flavor.HYBRID, (Object)Flavor.ordinalToFlavor((int)2));
        Assert.assertEquals((Object)Flavor.PINNED, (Object)Flavor.ordinalToFlavor((int)3));
        Assert.assertEquals((Object)Flavor.SLIDING, (Object)Flavor.ordinalToFlavor((int)4));
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

