/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.commons.text.similarity.SimilarityInput;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class LevenshteinDistanceTest {
    private static final LevenshteinDistance UNLIMITED_DISTANCE = LevenshteinDistance.getDefaultInstance();

    LevenshteinDistanceTest() {
    }

    @Test
    void testApplyThrowsIllegalArgumentExceptionSimilarityInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LevenshteinDistance(Integer.valueOf(0)).apply((SimilarityInput)null, (SimilarityInput)null));
    }

    @Test
    void testApplyThrowsIllegalArgumentExceptionString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)null, (CharSequence)null));
    }

    @Test
    void testConstructorWithNegativeThreshold() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LevenshteinDistance(Integer.valueOf(-1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    void testGetLevenshteinDistance(Class<?> cls) {
        Assertions.assertEquals((int)0, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)1, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "a")));
        Assertions.assertEquals((int)7, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)1, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")));
        Assertions.assertEquals((int)3, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")));
        Assertions.assertEquals((int)7, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)7, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "elephant")));
        Assertions.assertEquals((int)8, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "zzzzzzzz")));
        Assertions.assertEquals((int)8, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "zzzzzzzz"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)1, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hello"), SimilarityInputTest.build(cls, "hallo")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    void testGetLevenshteinDistance_NullString(Class<?> cls) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "a"), SimilarityInputTest.build(cls, null)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    void testGetLevenshteinDistance_NullStringInt(Class<?> cls) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, null), SimilarityInputTest.build(cls, "a")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    void testGetLevenshteinDistance_StringNull(Class<?> cls) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, null), SimilarityInputTest.build(cls, "a")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    void testGetLevenshteinDistance_StringNullInt(Class<?> cls) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "a"), SimilarityInputTest.build(cls, null)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    void testGetLevenshteinDistance_StringString(Class<?> cls) {
        Assertions.assertEquals((int)0, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)1, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "a")));
        Assertions.assertEquals((int)7, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)1, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")));
        Assertions.assertEquals((int)3, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")));
        Assertions.assertEquals((int)7, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)7, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "elephant")));
        Assertions.assertEquals((int)8, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "zzzzzzzz")));
        Assertions.assertEquals((int)8, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "zzzzzzzz"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)1, (Integer)UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hello"), SimilarityInputTest.build(cls, "hallo")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    void testGetLevenshteinDistance_StringStringInt(Class<?> cls) {
        Assertions.assertEquals((int)0, (Integer)new LevenshteinDistance(Integer.valueOf(0)).apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(8)).apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(7)).apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(6)).apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(0)).apply(SimilarityInputTest.build(cls, "b"), SimilarityInputTest.build(cls, "a")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(0)).apply(SimilarityInputTest.build(cls, "a"), SimilarityInputTest.build(cls, "b")));
        Assertions.assertEquals((int)0, (Integer)new LevenshteinDistance(Integer.valueOf(0)).apply(SimilarityInputTest.build(cls, "aa"), SimilarityInputTest.build(cls, "aa")));
        Assertions.assertEquals((int)0, (Integer)new LevenshteinDistance(Integer.valueOf(2)).apply(SimilarityInputTest.build(cls, "aa"), SimilarityInputTest.build(cls, "aa")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(2)).apply(SimilarityInputTest.build(cls, "aaa"), SimilarityInputTest.build(cls, "bbb")));
        Assertions.assertEquals((int)3, (Integer)new LevenshteinDistance(Integer.valueOf(3)).apply(SimilarityInputTest.build(cls, "aaa"), SimilarityInputTest.build(cls, "bbb")));
        Assertions.assertEquals((int)6, (Integer)new LevenshteinDistance(Integer.valueOf(10)).apply(SimilarityInputTest.build(cls, "aaaaaa"), SimilarityInputTest.build(cls, "b")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(8)).apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "b")));
        Assertions.assertEquals((int)3, (Integer)new LevenshteinDistance(Integer.valueOf(4)).apply(SimilarityInputTest.build(cls, "a"), SimilarityInputTest.build(cls, "bbb")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(7)).apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "b")));
        Assertions.assertEquals((int)3, (Integer)new LevenshteinDistance(Integer.valueOf(3)).apply(SimilarityInputTest.build(cls, "a"), SimilarityInputTest.build(cls, "bbb")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(2)).apply(SimilarityInputTest.build(cls, "a"), SimilarityInputTest.build(cls, "bbb")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(2)).apply(SimilarityInputTest.build(cls, "bbb"), SimilarityInputTest.build(cls, "a")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(6)).apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, "b")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(1)).apply(SimilarityInputTest.build(cls, "a"), SimilarityInputTest.build(cls, "bbb")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(1)).apply(SimilarityInputTest.build(cls, "bbb"), SimilarityInputTest.build(cls, "a")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(1)).apply(SimilarityInputTest.build(cls, "12345"), SimilarityInputTest.build(cls, "1234567")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(1)).apply(SimilarityInputTest.build(cls, "1234567"), SimilarityInputTest.build(cls, "12345")));
        Assertions.assertEquals((int)1, (Integer)new LevenshteinDistance(Integer.valueOf(1)).apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")));
        Assertions.assertEquals((int)3, (Integer)new LevenshteinDistance(Integer.valueOf(3)).apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(7)).apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(6)).apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(7)).apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "elephant")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(6)).apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "elephant")));
        Assertions.assertEquals((int)8, (Integer)new LevenshteinDistance(Integer.valueOf(8)).apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "zzzzzzzz")));
        Assertions.assertEquals((int)8, (Integer)new LevenshteinDistance(Integer.valueOf(8)).apply(SimilarityInputTest.build(cls, "zzzzzzzz"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)1, (Integer)new LevenshteinDistance(Integer.valueOf(1)).apply(SimilarityInputTest.build(cls, "hello"), SimilarityInputTest.build(cls, "hallo")));
        Assertions.assertEquals((int)1, (Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")));
        Assertions.assertEquals((int)3, (Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)7, (Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "elephant")));
        Assertions.assertEquals((int)8, (Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "zzzzzzzz")));
        Assertions.assertEquals((int)8, (Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply(SimilarityInputTest.build(cls, "zzzzzzzz"), SimilarityInputTest.build(cls, "hippo")));
        Assertions.assertEquals((int)1, (Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply(SimilarityInputTest.build(cls, "hello"), SimilarityInputTest.build(cls, "hallo")));
        Assertions.assertEquals((int)-1, (Integer)new LevenshteinDistance(Integer.valueOf(1)).apply(SimilarityInputTest.build(cls, "abc"), SimilarityInputTest.build(cls, "acb")));
    }

    @Test
    void testGetThresholdDirectlyAfterObjectInstantiation() {
        Assertions.assertNull((Object)LevenshteinDistance.getDefaultInstance().getThreshold());
    }
}

