/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.formats.png.AbstractPngTest;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.io.FilenameUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngMultipleRoundtripTest
extends AbstractPngTest {
    @Test
    public void test() throws Exception {
        File[] files;
        String imagesFolderPath = FilenameUtils.separatorsToSystem((String)(ImagingTestConstants.TEST_DATA_SOURCE_FOLDER + "/images/png/3"));
        File imagesFolder = new File(imagesFolderPath);
        Assertions.assertTrue((imagesFolder.exists() && imagesFolder.isDirectory() ? 1 : 0) != 0);
        for (File file : files = imagesFolder.listFiles()) {
            File imageFile = file;
            if (!imageFile.isFile() || !imageFile.getName().toLowerCase().endsWith(".png")) continue;
            Debug.debug();
            Debug.debug((String)"imageFile", (Object)imageFile);
            File lastFile = imageFile;
            for (int j = 0; j < 10; ++j) {
                BufferedImage image = Imaging.getBufferedImage((File)lastFile);
                Assertions.assertNotNull((Object)image);
                File tempFile = Files.createTempFile(imageFile.getName() + "." + j + ".", ".png", new FileAttribute[0]).toFile();
                Debug.debug((String)"tempFile", (Object)tempFile);
                Imaging.writeImage((BufferedImage)image, (File)tempFile, (ImageFormat)ImageFormats.PNG);
                lastFile = tempFile;
            }
        }
    }
}

