/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.command;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.shell.cli.RaftUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.function.CheckedFunction;

public abstract class AbstractRatisCommand
extends AbstractCommand {
    public static final String PEER_OPTION_NAME = "peers";
    public static final String GROUPID_OPTION_NAME = "groupid";
    public static final RaftGroupId DEFAULT_RAFT_GROUP_ID = RaftGroupId.randomId();
    private RaftGroup raftGroup;
    private GroupInfoReply groupInfoReply;

    public static <T, K, E extends Throwable> K run(Collection<T> list, CheckedFunction<T, K, E> function) {
        for (T t : list) {
            try {
                Object ret = function.apply(t);
                if (ret == null) continue;
                return (K)ret;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected AbstractRatisCommand(Context context) {
        super(context);
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        String[] peersArray;
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        String peersStr = cl.getOptionValue(PEER_OPTION_NAME);
        for (String peer : peersArray = peersStr.split(",")) {
            addresses.add(AbstractRatisCommand.parseInetSocketAddress(peer));
        }
        RaftGroupId raftGroupIdFromConfig = cl.hasOption(GROUPID_OPTION_NAME) ? RaftGroupId.valueOf((UUID)UUID.fromString(cl.getOptionValue(GROUPID_OPTION_NAME))) : DEFAULT_RAFT_GROUP_ID;
        List peers = addresses.stream().map(addr -> RaftPeer.newBuilder().setId(RaftUtils.getPeerId(addr)).setAddress(addr).build()).collect(Collectors.toList());
        this.raftGroup = RaftGroup.valueOf((RaftGroupId)raftGroupIdFromConfig, peers);
        try (RaftClient client = RaftUtils.createClient(this.raftGroup);){
            RaftGroupId remoteGroupId;
            if (raftGroupIdFromConfig != DEFAULT_RAFT_GROUP_ID) {
                remoteGroupId = raftGroupIdFromConfig;
            } else {
                List groupIds = (List)AbstractRatisCommand.run(peers, p -> client.getGroupManagementApi(p.getId()).list().getGroupIds());
                if (groupIds == null) {
                    this.println("Failed to get group ID from " + peers);
                    int n = -1;
                    return n;
                }
                if (groupIds.size() == 1) {
                    remoteGroupId = (RaftGroupId)groupIds.get(0);
                } else {
                    this.println("There are more than one groups, you should specific one. " + groupIds);
                    int n = -2;
                    return n;
                }
            }
            this.groupInfoReply = (GroupInfoReply)AbstractRatisCommand.run(peers, p -> client.getGroupManagementApi(p.getId()).info(remoteGroupId));
            this.processReply((RaftClientReply)this.groupInfoReply, () -> "Failed to get group info for group id " + remoteGroupId.getUuid() + " from " + peers);
            this.raftGroup = this.groupInfoReply.getGroup();
        }
        return 0;
    }

    @Override
    public Options getOptions() {
        return new Options().addOption(Option.builder().option(PEER_OPTION_NAME).hasArg().required().desc("Peer addresses seperated by comma").build()).addOption(GROUPID_OPTION_NAME, true, "Raft group id");
    }

    protected RaftGroup getRaftGroup() {
        return this.raftGroup;
    }

    protected GroupInfoReply getGroupInfoReply() {
        return this.groupInfoReply;
    }

    protected RaftProtos.RaftPeerProto getLeader(RaftProtos.RoleInfoProto roleInfo) {
        if (roleInfo == null) {
            return null;
        }
        if (roleInfo.getRole() == RaftProtos.RaftPeerRole.LEADER) {
            return roleInfo.getSelf();
        }
        RaftProtos.FollowerInfoProto followerInfo = roleInfo.getFollowerInfo();
        if (followerInfo == null) {
            return null;
        }
        return followerInfo.getLeaderInfo().getId();
    }

    protected void processReply(RaftClientReply reply, Supplier<String> messageSupplier) throws IOException {
        if (reply == null || !reply.isSuccess()) {
            RaftException e = Optional.ofNullable(reply).map(RaftClientReply::getException).orElseGet(() -> new RaftException("Reply: " + reply));
            String message = messageSupplier.get();
            this.printf("%s. Error: %s%n", message, e);
            throw new IOException(message, (Throwable)e);
        }
    }

    protected List<RaftPeerId> getIds(String[] optionValues, BiConsumer<RaftPeerId, InetSocketAddress> consumer) {
        if (optionValues == null) {
            return Collections.emptyList();
        }
        ArrayList<RaftPeerId> ids = new ArrayList<RaftPeerId>();
        for (String address : optionValues) {
            InetSocketAddress serverAddress = AbstractRatisCommand.parseInetSocketAddress(address);
            RaftPeerId peerId = RaftUtils.getPeerId(serverAddress);
            consumer.accept(peerId, serverAddress);
            ids.add(peerId);
        }
        return ids;
    }

    protected Stream<RaftPeer> getPeerStream(RaftProtos.RaftPeerRole role) {
        RaftProtos.RaftConfigurationProto conf = this.groupInfoReply.getConf().orElse(null);
        if (conf == null) {
            return role == RaftProtos.RaftPeerRole.FOLLOWER ? this.getRaftGroup().getPeers().stream() : Stream.empty();
        }
        Set targets = (role == RaftProtos.RaftPeerRole.LISTENER ? conf.getListenersList() : conf.getPeersList()).stream().map(ProtoUtils::toRaftPeer).collect(Collectors.toSet());
        return this.getRaftGroup().getPeers().stream().filter(targets::contains);
    }
}

