/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.AlreadyClosedException;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.MemoryFileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.FileChannelUtils;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.congestcontrol.BufferStatusHub;
import org.apache.celeborn.service.deploy.worker.congestcontrol.CongestionController;
import org.apache.celeborn.service.deploy.worker.congestcontrol.UserBufferInfo;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.HdfsFlushTask;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlushTask;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriterContext;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple4;

public abstract class PartitionDataWriter
implements DeviceObserver {
    private static final Logger logger = LoggerFactory.getLogger(PartitionDataWriter.class);
    private static final long WAIT_INTERVAL_MS = 5L;
    protected DiskFileInfo diskFileInfo = null;
    protected MemoryFileInfo memoryFileInfo = null;
    private FileChannel channel;
    private volatile boolean closed;
    private volatile boolean destroyed;
    protected final AtomicInteger numPendingWrites = new AtomicInteger();
    public Flusher flusher;
    private int flushWorkerIndex;
    protected CompositeByteBuf flushBuffer;
    protected final Object flushLock = new Object();
    private final long writerCloseTimeoutMs;
    protected long flusherBufferSize;
    protected final DeviceMonitor deviceMonitor;
    protected final AbstractSource source;
    private final long splitThreshold;
    private final PartitionSplitMode splitMode;
    private final boolean rangeReadFilter;
    protected boolean deleted = false;
    private RoaringBitmap mapIdBitMap = null;
    protected final FlushNotifier notifier = new FlushNotifier();
    private final String shuffleKey;
    protected final StorageManager storageManager;
    private final boolean workerGracefulShutdown;
    protected final long memoryFileStorageMaxFileSize;
    protected AtomicBoolean isMemoryShuffleFile = new AtomicBoolean();
    protected final String filename;
    protected PooledByteBufAllocator pooledByteBufAllocator;
    private final PartitionDataWriterContext writerContext;
    private final long localFlusherBufferSize;
    private final long hdfsFlusherBufferSize;
    private Exception exception = null;
    private boolean metricsCollectCriticalEnabled;
    private long chunkSize;
    private UserBufferInfo userBufferInfo = null;

    public PartitionDataWriter(StorageManager storageManager, AbstractSource workerSource, CelebornConf conf, DeviceMonitor deviceMonitor, PartitionDataWriterContext writerContext, boolean supportInMemory) throws IOException {
        this.storageManager = storageManager;
        this.writerCloseTimeoutMs = conf.workerWriterCloseTimeoutMs();
        this.workerGracefulShutdown = conf.workerGracefulShutdown();
        this.splitThreshold = writerContext.getSplitThreshold();
        this.deviceMonitor = deviceMonitor;
        this.splitMode = writerContext.getPartitionSplitMode();
        this.rangeReadFilter = writerContext.isRangeReadFilter();
        this.shuffleKey = writerContext.getShuffleKey();
        this.memoryFileStorageMaxFileSize = conf.workerMemoryFileStorageMaxFileSize();
        this.filename = writerContext.getPartitionLocation().getFileName();
        this.writerContext = writerContext;
        this.localFlusherBufferSize = conf.workerFlusherBufferSize();
        this.hdfsFlusherBufferSize = conf.workerHdfsFlusherBufferSize();
        this.metricsCollectCriticalEnabled = conf.metricsCollectCriticalEnabled();
        this.chunkSize = conf.shuffleChunkSize();
        Tuple4<MemoryFileInfo, Flusher, DiskFileInfo, File> createFileResult = storageManager.createFile(writerContext, supportInMemory);
        if (supportInMemory && createFileResult._1() != null) {
            this.memoryFileInfo = (MemoryFileInfo)createFileResult._1();
            this.pooledByteBufAllocator = storageManager.storageBufferAllocator();
            this.isMemoryShuffleFile.set(true);
            storageManager.registerMemoryPartitionWriter(this, (MemoryFileInfo)createFileResult._1());
        } else if (createFileResult._2() != null) {
            this.diskFileInfo = (DiskFileInfo)createFileResult._3();
            this.flusher = (Flusher)createFileResult._2();
            this.flushWorkerIndex = this.flusher.getWorkerIndex();
            File workingDir = (File)createFileResult._4();
            this.isMemoryShuffleFile.set(false);
            this.initFileChannelsForDiskFile();
            storageManager.registerDiskFilePartitionWriter(this, workingDir, this.diskFileInfo);
        } else {
            throw new CelebornIOException("Create file failed for location:" + writerContext.getPartitionLocation().toString());
        }
        this.source = workerSource;
        logger.debug("FileWriter {} split threshold {} mode {}", new Object[]{this, this.splitThreshold, this.splitMode});
        if (this.rangeReadFilter) {
            this.mapIdBitMap = new RoaringBitmap();
        }
        this.takeBuffer();
        CongestionController congestionController = CongestionController.instance();
        if (!this.isMemoryShuffleFile.get() && congestionController != null) {
            this.userBufferInfo = congestionController.getUserBuffer(this.getDiskFileInfo().getUserIdentifier());
        }
    }

    public void initFileChannelsForDiskFile() throws IOException {
        if (!this.diskFileInfo.isHdfs()) {
            this.flusherBufferSize = this.localFlusherBufferSize;
            this.channel = FileChannelUtils.createWritableFileChannel((String)this.diskFileInfo.getFilePath());
        } else {
            this.flusherBufferSize = this.hdfsFlusherBufferSize;
            try {
                StorageManager.hadoopFs().create(this.diskFileInfo.getHdfsPath(), true).close();
            }
            catch (IOException e) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                StorageManager.hadoopFs().create(this.diskFileInfo.getHdfsPath(), true).close();
            }
        }
    }

    public DiskFileInfo getDiskFileInfo() {
        return this.diskFileInfo;
    }

    public File getFile() {
        return this.diskFileInfo.getFile();
    }

    public void incrementPendingWrites() {
        this.numPendingWrites.incrementAndGet();
    }

    public void decrementPendingWrites() {
        this.numPendingWrites.decrementAndGet();
    }

    @VisibleForTesting
    public void flush(boolean finalFlush, boolean fromEvict) throws IOException {
        int numBytes;
        if (this.flushBuffer != null && (numBytes = this.flushBuffer.readableBytes()) != 0) {
            this.notifier.checkException();
            FlushTask task = null;
            if (fromEvict) {
                this.notifier.numPendingFlushes.incrementAndGet();
                ByteBuf dupBuf = this.flushBuffer.retainedDuplicate();
                if (this.channel != null) {
                    task = new LocalFlushTask(this.flushBuffer, this.channel, this.notifier, false);
                } else if (this.diskFileInfo.isHdfs()) {
                    task = new HdfsFlushTask(this.flushBuffer, this.diskFileInfo.getHdfsPath(), this.notifier, false);
                }
                MemoryManager.instance().releaseMemoryFileStorage(numBytes);
                MemoryManager.instance().incrementDiskBuffer(numBytes);
                if ((long)numBytes > this.chunkSize) {
                    ByteBuffer headerBuf = ByteBuffer.allocate(16);
                    while (dupBuf.isReadable()) {
                        headerBuf.rewind();
                        dupBuf.readBytes(headerBuf);
                        byte[] batchHeader = headerBuf.array();
                        int compressedSize = Platform.getInt((Object)batchHeader, (long)(Platform.BYTE_ARRAY_OFFSET + 12));
                        dupBuf.skipBytes(compressedSize);
                        this.diskFileInfo.updateBytesFlushed((long)(compressedSize + 16));
                    }
                    dupBuf.release();
                } else {
                    this.diskFileInfo.updateBytesFlushed((long)numBytes);
                }
            } else if (!this.isMemoryShuffleFile.get()) {
                this.notifier.numPendingFlushes.incrementAndGet();
                if (this.channel != null) {
                    task = new LocalFlushTask(this.flushBuffer, this.channel, this.notifier, true);
                } else if (this.diskFileInfo.isHdfs()) {
                    task = new HdfsFlushTask(this.flushBuffer, this.diskFileInfo.getHdfsPath(), this.notifier, true);
                }
            }
            if (task != null) {
                this.addTask(task);
                this.flushBuffer = null;
                if (!fromEvict) {
                    this.diskFileInfo.updateBytesFlushed((long)numBytes);
                }
                if (!finalFlush) {
                    this.takeBuffer();
                }
            }
        }
    }

    public boolean needHardSplitForMemoryShuffleStorage() {
        if (!this.isMemoryShuffleFile.get()) {
            return false;
        }
        return !this.storageManager.localOrHdfsStorageAvailable() && (this.memoryFileInfo.getFileLength() > this.memoryFileStorageMaxFileSize || !MemoryManager.instance().memoryFileStorageAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf data) throws IOException {
        if (this.closed) {
            String msg = this.getFileAlreadyClosedMsg();
            logger.warn(msg);
            throw new AlreadyClosedException(msg);
        }
        if (this.notifier.hasException()) {
            return;
        }
        int mapId = 0;
        if (this.rangeReadFilter) {
            byte[] header = new byte[4];
            data.markReaderIndex();
            data.readBytes(header);
            data.resetReaderIndex();
            mapId = Platform.getInt((Object)header, (long)Platform.BYTE_ARRAY_OFFSET);
        }
        int numBytes = data.readableBytes();
        Object object = this.flushLock;
        synchronized (object) {
            if (this.closed) {
                String msg = this.getFileAlreadyClosedMsg();
                logger.warn(msg);
                throw new AlreadyClosedException(msg);
            }
            if (this.rangeReadFilter) {
                this.mapIdBitMap.add(mapId);
            }
            int flushBufferReadableBytes = this.flushBuffer.readableBytes();
            if (!this.isMemoryShuffleFile.get()) {
                if (flushBufferReadableBytes != 0 && (long)(flushBufferReadableBytes + numBytes) >= this.flusherBufferSize) {
                    this.flush(false, false);
                }
            } else if ((long)flushBufferReadableBytes > this.memoryFileStorageMaxFileSize && this.storageManager.localOrHdfsStorageAvailable()) {
                logger.debug("{} Evict, memory buffer is  {}", (Object)this.writerContext.getPartitionLocation().getFileName(), (Object)flushBufferReadableBytes);
                this.evict(false);
            }
            if (this.isMemoryShuffleFile.get()) {
                MemoryManager.instance().incrementMemoryFileStorage(numBytes);
            } else {
                MemoryManager.instance().incrementDiskBuffer(numBytes);
                if (this.userBufferInfo != null) {
                    this.userBufferInfo.updateInfo(System.currentTimeMillis(), new BufferStatusHub.BufferStatusNode(numBytes));
                }
            }
            data.retain();
            try {
                this.flushBuffer.addComponent(true, data);
            }
            catch (OutOfMemoryError oom) {
                data.release();
                if (this.isMemoryShuffleFile.get()) {
                    MemoryManager.instance().releaseMemoryFileStorage(numBytes);
                } else {
                    MemoryManager.instance().releaseDiskBuffer(numBytes);
                }
                throw oom;
            }
            if (this.isMemoryShuffleFile.get()) {
                this.memoryFileInfo.updateBytesFlushed((long)numBytes);
            }
        }
        this.numPendingWrites.decrementAndGet();
    }

    public void evictInternal() throws IOException {
        if (this.exception != null) {
            return;
        }
        Tuple4<MemoryFileInfo, Flusher, DiskFileInfo, File> createFileResult = this.storageManager.createFile(this.writerContext, false);
        if (createFileResult._4() == null) {
            this.exception = new CelebornIOException("PartitionDataWriter create disk-related file failed");
            throw (CelebornIOException)((Object)this.exception);
        }
        this.diskFileInfo = (DiskFileInfo)createFileResult._3();
        this.flusher = (Flusher)createFileResult._2();
        this.flushWorkerIndex = this.flusher.getWorkerIndex();
        this.isMemoryShuffleFile.set(false);
        this.initFileChannelsForDiskFile();
        this.flush(this.closed, true);
        logger.debug("evict {} {}", (Object)this.shuffleKey, (Object)this.filename);
        this.storageManager.unregisterMemoryPartitionWriterAndFileInfo(this.memoryFileInfo, this.shuffleKey, this.filename);
        this.storageManager.evictedFileCount().incrementAndGet();
        this.memoryFileInfo = null;
    }

    public RoaringBitmap getMapIdBitMap() {
        return this.mapIdBitMap;
    }

    public StorageInfo getStorageInfo() {
        if (this.diskFileInfo != null) {
            if (this.diskFileInfo.isHdfs()) {
                if (this.deleted) {
                    return null;
                }
                return new StorageInfo(StorageInfo.Type.HDFS, true, this.diskFileInfo.getFilePath());
            }
            return new StorageInfo(((LocalFlusher)this.flusher).diskType(), true, "");
        }
        Preconditions.checkArgument((this.memoryFileInfo != null ? 1 : 0) != 0);
        return new StorageInfo(StorageInfo.Type.MEMORY, true, "");
    }

    public abstract long close() throws IOException;

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long close(RunnableWithIOException tryClose, RunnableWithIOException streamClose, RunnableWithIOException finalClose) throws IOException {
        if (this.closed) {
            String msg = this.getFileAlreadyClosedMsg();
            logger.error(msg);
            throw new AlreadyClosedException(msg);
        }
        try {
            this.waitOnNoPending(this.numPendingWrites, false);
            this.closed = true;
            Object msg = this.flushLock;
            synchronized (msg) {
                if (!this.isMemoryShuffleFile.get() && this.flushBuffer != null && this.flushBuffer.readableBytes() > 0) {
                    this.flush(true, false);
                }
            }
            tryClose.run();
            this.waitOnNoPending(this.notifier.numPendingFlushes, true);
        }
        finally {
            this.returnBuffer(false);
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
                streamClose.run();
            }
            catch (IOException e) {
                logger.warn("close file writer {} failed", (Object)this, (Object)e);
            }
            finalClose.run();
            if (this.diskFileInfo != null && !this.diskFileInfo.isHdfs()) {
                logger.debug("file info {} unregister from device monitor", (Object)this.diskFileInfo);
                this.deviceMonitor.unregisterFileWriter(this);
            }
        }
        if (this.workerGracefulShutdown && this.diskFileInfo != null) {
            this.storageManager.notifyFileInfoCommitted(this.shuffleKey, this.getFile().getName(), this.diskFileInfo);
        }
        if (this.diskFileInfo != null) {
            return this.diskFileInfo.getFileLength();
        }
        return this.memoryFileInfo.getFileLength();
    }

    private String getFileAlreadyClosedMsg() {
        String msg = "PartitionDataWriter has already closed! ";
        msg = this.isMemoryShuffleFile.get() ? msg + "In memory file name:" + this.filename : msg + "Disk file name:" + this.diskFileInfo.getFilePath();
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(boolean checkClose) throws IOException {
        Object object = this.flushLock;
        synchronized (object) {
            if (checkClose && this.isClosed()) {
                return;
            }
            if (this.memoryFileInfo != null) {
                this.evictInternal();
                if (this.isClosed()) {
                    this.waitOnNoPending(this.notifier.numPendingFlushes, true);
                    this.storageManager.notifyFileInfoCommitted(this.shuffleKey, this.getFile().getName(), this.diskFileInfo);
                }
            }
        }
    }

    public synchronized void destroy(IOException ioException) {
        if (!this.closed) {
            this.closed = true;
            if (!this.notifier.hasException()) {
                this.notifier.setException(ioException);
            }
            this.returnBuffer(true);
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                logger.warn("Close channel failed for file {} caused by {}.", (Object)this.diskFileInfo.getFilePath(), (Object)e.getMessage());
            }
        }
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.diskFileInfo != null) {
                this.diskFileInfo.deleteAllFiles(StorageManager.hadoopFs());
                if (!this.diskFileInfo.isHdfs()) {
                    this.deviceMonitor.unregisterFileWriter(this);
                }
            }
        }
    }

    public FileInfo getCurrentFileInfo() {
        if (!this.isMemoryShuffleFile.get()) {
            return this.diskFileInfo;
        }
        return this.memoryFileInfo;
    }

    public IOException getException() {
        if (this.notifier.hasException()) {
            return this.notifier.exception.get();
        }
        return null;
    }

    protected void waitOnNoPending(AtomicInteger counter, boolean failWhenTimeout) throws IOException {
        for (long waitTime = this.writerCloseTimeoutMs; counter.get() > 0 && waitTime > 0L; waitTime -= 5L) {
            try {
                this.notifier.checkException();
                TimeUnit.MILLISECONDS.sleep(5L);
                continue;
            }
            catch (InterruptedException e) {
                IOException ioe = new IOException(e);
                this.notifier.setException(ioe);
                throw ioe;
            }
        }
        if (counter.get() > 0 && failWhenTimeout) {
            IOException ioe = new IOException("Wait pending actions timeout, Counter: " + counter.get());
            this.notifier.setException(ioe);
            throw ioe;
        }
        this.notifier.checkException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void takeBuffer() {
        String metricsName = null;
        String fileAbsPath = null;
        if (this.metricsCollectCriticalEnabled) {
            metricsName = WorkerSource.TAKE_BUFFER_TIME();
            fileAbsPath = this.diskFileInfo.getFilePath();
            this.source.startTimer(metricsName, fileAbsPath);
        }
        Object object = this.flushLock;
        synchronized (object) {
            if (this.diskFileInfo != null) {
                this.flushBuffer = this.flusher.takeBuffer();
            } else if (this.flushBuffer == null) {
                this.flushBuffer = this.pooledByteBufAllocator.compositeBuffer(Integer.MAX_VALUE);
            }
        }
        if (this.metricsCollectCriticalEnabled) {
            this.source.stopTimer(metricsName, fileAbsPath);
        }
    }

    protected void addTask(FlushTask task) throws IOException {
        if (!this.flusher.addTask(task, this.writerCloseTimeoutMs, this.flushWorkerIndex)) {
            IOException e = new IOException("Add flush task timeout.");
            this.notifier.setException(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnBuffer(boolean destroy) {
        Object object = this.flushLock;
        synchronized (object) {
            if (this.flushBuffer != null) {
                if (this.flusher != null) {
                    this.flusher.returnBuffer(this.flushBuffer, true);
                    this.flushBuffer = null;
                } else if (destroy) {
                    this.flushBuffer.removeComponents(0, this.flushBuffer.numComponents());
                    this.flushBuffer.release();
                }
            }
        }
    }

    public int hashCode() {
        return this.diskFileInfo.getFilePath().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PartitionDataWriter && this.diskFileInfo.getFilePath().equals(((PartitionDataWriter)obj).diskFileInfo.getFilePath());
    }

    public String toString() {
        return this.shuffleKey + "-" + this.filename + " partition-writer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOnMemoryPressure() throws IOException {
        Object object = this.flushLock;
        synchronized (object) {
            this.flush(false, false);
        }
    }

    public long getSplitThreshold() {
        return this.splitThreshold;
    }

    public PartitionSplitMode getSplitMode() {
        return this.splitMode;
    }

    @Override
    public void notifyError(String mountPoint, DiskStatus diskStatus) {
        this.destroy(new IOException("Destroy FileWriter " + this + " by device ERROR. Disk: " + mountPoint + " Status: " + diskStatus));
    }

    @Override
    public void notifyHealthy(String mountPoint) {
    }

    @Override
    public void notifyHighDiskUsage(String mountPoint) {
    }

    @Override
    public void notifyNonCriticalError(String mountPoint, DiskStatus diskStatus) {
    }

    public MemoryFileInfo getMemoryFileInfo() {
        return this.memoryFileInfo;
    }

    @FunctionalInterface
    public static interface RunnableWithIOException {
        public void run() throws IOException;
    }
}

