/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.util.List;
import java.util.Map;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.DynamicConfig;
import org.apache.celeborn.server.common.service.model.ClusterTenantConfig;

public class TenantConfig
extends DynamicConfig {
    private final String tenantId;
    private final ConfigService configService;
    private final String name;

    public TenantConfig(ConfigService configService, String tenantId, String name, Map<String, String> configs) {
        this.configService = configService;
        this.tenantId = tenantId;
        this.name = name;
        this.configs.putAll(configs);
    }

    public TenantConfig(ConfigService configService, String tenantId, String name, List<ClusterTenantConfig> tenantConfigs) {
        this.configService = configService;
        this.tenantId = tenantId;
        this.name = name;
        tenantConfigs.forEach(t -> this.configs.put(t.getConfigKey(), t.getConfigValue()));
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DynamicConfig getParentLevelConfig() {
        if (this.name == null) {
            return this.configService.getSystemConfigFromCache();
        }
        return this.configService.getTenantConfigFromCache(this.tenantId);
    }
}

