/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.SystemConfig;
import org.apache.celeborn.server.common.service.config.TenantConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfigServiceImpl
implements ConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConfigServiceImpl.class);
    protected final CelebornConf celebornConf;
    protected final AtomicReference<SystemConfig> systemConfigAtomicReference = new AtomicReference();
    protected final AtomicReference<Map<String, TenantConfig>> tenantConfigAtomicReference = new AtomicReference(new HashMap());
    protected final AtomicReference<Map<Pair<String, String>, TenantConfig>> tenantUserConfigAtomicReference = new AtomicReference(new HashMap());
    private final ScheduledExecutorService configRefreshService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"celeborn-config-refresher");

    public BaseConfigServiceImpl(CelebornConf celebornConf) throws IOException {
        this.celebornConf = celebornConf;
        this.systemConfigAtomicReference.set(new SystemConfig(celebornConf));
        this.refreshCache();
        long dynamicConfigRefreshInterval = celebornConf.dynamicConfigRefreshInterval();
        this.configRefreshService.scheduleWithFixedDelay(() -> {
            try {
                this.refreshCache();
            }
            catch (Throwable e) {
                LOG.error("Failed to refresh dynamic configs. Encounter exception: {}.", (Object)e.getMessage(), (Object)e);
            }
        }, dynamicConfigRefreshInterval, dynamicConfigRefreshInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public CelebornConf getCelebornConf() {
        return this.celebornConf;
    }

    @Override
    public SystemConfig getSystemConfigFromCache() {
        return this.systemConfigAtomicReference.get();
    }

    @Override
    public List<TenantConfig> listRawTenantConfigsFromCache() {
        return new ArrayList<TenantConfig>(this.tenantConfigAtomicReference.get().values());
    }

    @Override
    public TenantConfig getRawTenantConfigFromCache(String tenantId) {
        return this.tenantConfigAtomicReference.get().get(tenantId);
    }

    @Override
    public List<TenantConfig> listRawTenantUserConfigsFromCache() {
        return new ArrayList<TenantConfig>(this.tenantUserConfigAtomicReference.get().values());
    }

    @Override
    public TenantConfig getRawTenantUserConfigFromCache(String tenantId, String userId) {
        return this.tenantUserConfigAtomicReference.get().get(Pair.of((Object)tenantId, (Object)userId));
    }

    @Override
    public void shutdown() {
        ThreadUtils.shutdown((ExecutorService)this.configRefreshService);
    }
}

