/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CdcUtil {
    private static final String SEPARATOR = "-";
    private static final String FILENAME_PREFIX = "CommitLog-";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String IDX_FILE_EXTENSION = "_cdc.idx";
    private static final int LOG_FILE_EXTENSION_LENGTH = ".log".length();
    private static final int IDX_FILE_EXTENSION_LENGTH = "_cdc.idx".length();
    private static final String LOG_FILE_COMPLETE_INDICATOR = "COMPLETED";
    private static final String FILENAME_EXTENSION = "(_cdc.idx|.log)";
    static final Pattern SEGMENT_PATTERN = Pattern.compile("CommitLog-(?:\\d+-)?(\\d+)(_cdc.idx|.log)");
    public static final Pattern IDX_FILE_PATTERN = Pattern.compile("CommitLog-(?:\\d+-)?(\\d+)_cdc.idx");
    private static final int READ_INDEX_FILE_MAX_RETRY = 5;

    private CdcUtil() {
        throw new UnsupportedOperationException("Do not instantiate.");
    }

    public static String getIdxFilePrefix(String idxFileName) {
        return idxFileName.substring(0, idxFileName.length() - IDX_FILE_EXTENSION_LENGTH);
    }

    public static String getLogFilePrefix(String logFileName) {
        return logFileName.substring(0, logFileName.length() - LOG_FILE_EXTENSION_LENGTH);
    }

    public static String getIdxFileName(String logFileName) {
        return logFileName.replace(LOG_FILE_EXTENSION, IDX_FILE_EXTENSION);
    }

    public static File getIdxFile(File logFile) {
        return new File(logFile.getParent(), CdcUtil.getIdxFileName(logFile.getName()));
    }

    public static String getLogFileName(String indexFileName) {
        return indexFileName.replace(IDX_FILE_EXTENSION, LOG_FILE_EXTENSION);
    }

    public static CdcIndex parseIndexFile(File indexFile, long segmentFileLength) throws IOException {
        List<String> lines = null;
        for (int i = 0; i < 5; ++i) {
            try {
                lines = Files.readAllLines(indexFile.toPath());
                if (lines.isEmpty()) continue;
                break;
            }
            catch (IOException e) {
                throw new IOException("Unable to parse the CDC segment index file " + indexFile.getName(), e);
            }
        }
        if (lines.isEmpty()) {
            throw new IOException("Unable to read anything from the CDC segment index file " + indexFile.getName());
        }
        String lastLine = lines.get(lines.size() - 1);
        boolean isCompleted = lastLine.equals(LOG_FILE_COMPLETE_INDICATOR);
        long latestPosition = isCompleted ? segmentFileLength : Long.parseLong(lastLine);
        return new CdcIndex(latestPosition, isCompleted);
    }

    public static String idxToLogFileName(String idxFileName) {
        return idxFileName.substring(0, idxFileName.length() - IDX_FILE_EXTENSION.length()) + LOG_FILE_EXTENSION;
    }

    public static long parseSegmentId(String name) {
        Matcher matcher = SEGMENT_PATTERN.matcher(name);
        if (matcher.matches()) {
            return Long.parseLong(matcher.group(1));
        }
        throw new IllegalStateException("Invalid CommitLog name: " + name);
    }

    public static boolean isValid(String fileName) {
        return SEGMENT_PATTERN.matcher(fileName).matches();
    }

    public static boolean isLogFile(String fileName) {
        return CdcUtil.isValid(fileName) && fileName.endsWith(LOG_FILE_EXTENSION);
    }

    public static boolean isValidIdxFile(String idxFileName) {
        return IDX_FILE_PATTERN.matcher(idxFileName).matches();
    }

    public static boolean isIndexFile(String fileName) {
        return CdcUtil.isValid(fileName) && CdcUtil.matchIndexExtension(fileName);
    }

    public static boolean matchIndexExtension(String fileName) {
        return fileName.endsWith(IDX_FILE_EXTENSION);
    }

    public static class CdcIndex {
        public final long latestFlushPosition;
        public final boolean isCompleted;

        public CdcIndex(long latestFlushPosition, boolean isCompleted) {
            this.latestFlushPosition = latestFlushPosition;
            this.isCompleted = isCompleted;
        }
    }
}

