/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.cdc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Handler;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.request.Service;
import org.apache.cassandra.sidecar.common.request.data.AllServicesConfigPayload;
import org.apache.cassandra.sidecar.db.ConfigAccessor;
import org.apache.cassandra.sidecar.db.ConfigAccessorFactory;
import org.apache.cassandra.sidecar.handlers.AccessProtected;

@Singleton
public class AllServiceConfigHandler
implements Handler<RoutingContext>,
AccessProtected {
    private final ConfigAccessorFactory configAccessorFactory;

    @Inject
    public AllServiceConfigHandler(ConfigAccessorFactory configAccessorFactory) {
        this.configAccessorFactory = configAccessorFactory;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CDC.toAuthorization());
    }

    public void handle(RoutingContext context) {
        ArrayList<AllServicesConfigPayload.Service> services = new ArrayList<AllServicesConfigPayload.Service>();
        for (Service service : Service.values()) {
            ConfigAccessor accessor = this.configAccessorFactory.configAccessor(service);
            Map<String, String> config = accessor.getConfig().getConfigs();
            AllServicesConfigPayload.Service serviceConfig = new AllServicesConfigPayload.Service(service.serviceName, config);
            services.add(serviceConfig);
        }
        AllServicesConfigPayload payload = new AllServicesConfigPayload(services);
        context.json((Object)payload);
    }
}

