/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.ProtocolVersion;

public class SinglePartitionPager
extends AbstractQueryPager<SinglePartitionReadQuery> {
    private volatile PagingState.RowMark lastReturned;

    public SinglePartitionPager(SinglePartitionReadQuery query, PagingState state, ProtocolVersion protocolVersion) {
        super(query, protocolVersion);
        if (state != null) {
            this.lastReturned = state.rowMark;
            this.restoreState(query.partitionKey(), state.remaining, state.remainingInPartition);
        }
    }

    private SinglePartitionPager(SinglePartitionReadQuery query, ProtocolVersion protocolVersion, PagingState.RowMark rowMark, int remaining, int remainingInPartition) {
        super(query, protocolVersion);
        this.lastReturned = rowMark;
        this.restoreState(query.partitionKey(), remaining, remainingInPartition);
    }

    @Override
    public SinglePartitionPager withUpdatedLimit(DataLimits newLimits) {
        return new SinglePartitionPager(((SinglePartitionReadQuery)this.query).withUpdatedLimit(newLimits), this.protocolVersion, this.lastReturned, this.maxRemaining(), this.remainingInPartition());
    }

    public ByteBuffer key() {
        return ((SinglePartitionReadQuery)this.query).partitionKey().getKey();
    }

    public DataLimits limits() {
        return ((SinglePartitionReadQuery)this.query).limits();
    }

    @Override
    public PagingState state() {
        return this.lastReturned == null ? null : new PagingState(null, this.lastReturned, this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    protected SinglePartitionReadQuery nextPageReadQuery(int pageSize) {
        Clustering<?> clustering = this.lastReturned == null ? null : this.lastReturned.clustering(((SinglePartitionReadQuery)this.query).metadata());
        DataLimits limits = this.lastReturned == null ? this.limits().forPaging(pageSize) : this.limits().forPaging(pageSize, this.key(), this.remainingInPartition());
        return ((SinglePartitionReadQuery)this.query).forPaging(clustering, limits);
    }

    @Override
    protected void recordLast(DecoratedKey key, Row last) {
        if (last != null && last.clustering() != Clustering.STATIC_CLUSTERING) {
            this.lastReturned = PagingState.RowMark.create(((SinglePartitionReadQuery)this.query).metadata(), last, this.protocolVersion);
        }
    }

    @Override
    protected boolean isPreviouslyReturnedPartition(DecoratedKey key) {
        return this.lastReturned != null;
    }
}

