/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.incubator.metrics.ExtendedLongHistogramBuilder;
import io.opentelemetry.api.incubator.metrics.ExtendedLongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.util.Arrays;

final class HttpExperimentalMetricsAdvice {
    private static final AttributeKey<String> URL_TEMPLATE = AttributeKey.stringKey((String)"url.template");

    static void applyClientRequestSizeAdvice(LongHistogramBuilder builder) {
        if (!(builder instanceof ExtendedLongHistogramBuilder)) {
            return;
        }
        ((ExtendedLongHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_REQUEST_METHOD, HttpAttributes.HTTP_RESPONSE_STATUS_CODE, ErrorAttributes.ERROR_TYPE, NetworkAttributes.NETWORK_PROTOCOL_NAME, NetworkAttributes.NETWORK_PROTOCOL_VERSION, ServerAttributes.SERVER_ADDRESS, ServerAttributes.SERVER_PORT, URL_TEMPLATE));
    }

    static void applyServerRequestSizeAdvice(LongHistogramBuilder builder) {
        if (!(builder instanceof ExtendedLongHistogramBuilder)) {
            return;
        }
        ((ExtendedLongHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_ROUTE, HttpAttributes.HTTP_REQUEST_METHOD, HttpAttributes.HTTP_RESPONSE_STATUS_CODE, ErrorAttributes.ERROR_TYPE, NetworkAttributes.NETWORK_PROTOCOL_NAME, NetworkAttributes.NETWORK_PROTOCOL_VERSION, UrlAttributes.URL_SCHEME));
    }

    static void applyServerActiveRequestsAdvice(LongUpDownCounterBuilder builder) {
        if (!(builder instanceof ExtendedLongUpDownCounterBuilder)) {
            return;
        }
        ((ExtendedLongUpDownCounterBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_REQUEST_METHOD, UrlAttributes.URL_SCHEME));
    }

    private HttpExperimentalMetricsAdvice() {
    }
}

