/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.QuorumX509Util;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.AuthRequest;
import org.apache.zookeeper.server.admin.Command;
import org.apache.zookeeper.server.admin.CommandResponse;
import org.apache.zookeeper.server.admin.Commands;
import org.apache.zookeeper.server.admin.GetCommand;
import org.apache.zookeeper.server.admin.JettyAdminServer;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.zookeeper.server.auth.X509AuthenticationProvider;
import org.apache.zookeeper.test.ClientBase;
import org.eclipse.jetty.http.HttpHeader;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class CommandAuthTest
extends ZKTestCase {
    private static final String DIGEST_SCHEMA = "digest";
    private static final String X509_SCHEMA = "x509";
    private static final String IP_SCHEMA = "ip";
    private static final String ROOT_USER = "root";
    private static final String ROOT_PASSWORD = "root_passwd";
    private static final String AUTH_TEST_COMMAND_NAME = "authtest";
    private static final String X509_SUBJECT_PRINCIPAL = "CN=localhost,OU=ZooKeeper,O=Apache,L=Unknown,ST=Unknown,C=Unknown";
    private final int jettyAdminPort = PortAssignment.unique();
    private final String hostPort = "127.0.0.1:" + PortAssignment.unique();
    private final ClientX509Util clientX509Util = new ClientX509Util();
    private final QuorumX509Util quorumX509Util = new QuorumX509Util();
    private ZooKeeperServer zks;
    private ServerCnxnFactory cnxnFactory;
    private JettyAdminServer adminServer;
    private ZooKeeper zk;
    @TempDir
    static File dataDir;
    @TempDir
    static File logDir;

    @BeforeAll
    public void setup() throws Exception {
        Commands.registerCommand((Command)new AuthTestCommand(true, 31, "/"));
        this.setupTLS();
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        this.zks = new ZooKeeperServer(dataDir, logDir, 3000);
        int port = Integer.parseInt(this.hostPort.split(":")[1]);
        this.cnxnFactory = ServerCnxnFactory.createFactory((int)port, (int)-1);
        this.cnxnFactory.startup(this.zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(this.hostPort, 120000L));
        System.setProperty("zookeeper.admin.enableServer", "true");
        System.setProperty("zookeeper.admin.serverPort", String.valueOf(this.jettyAdminPort));
        this.adminServer = new JettyAdminServer();
        this.adminServer.setZooKeeperServer(this.zks);
        this.adminServer.start();
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.clearTLS();
        System.clearProperty("zookeeper.4lw.commands.whitelist");
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.admin.serverPort");
        if (this.adminServer != null) {
            this.adminServer.shutdown();
        }
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
        if (this.zks != null) {
            this.zks.shutdown();
        }
    }

    @BeforeEach
    public void setupEach() throws Exception {
        this.zk = ClientBase.createZKClient(this.hostPort);
    }

    @AfterEach
    public void tearDownEach() throws Exception {
        if (this.zk != null) {
            this.zk.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=AuthSchema.class)
    public void testAuthCheck_authorized(AuthSchema authSchema) throws Exception {
        this.setupRootACL(authSchema);
        try {
            HttpURLConnection authTestConn = this.sendAuthTestCommandRequest(authSchema, true);
            Assertions.assertEquals((int)200, (int)authTestConn.getResponseCode());
        }
        finally {
            this.addAuthInfo(this.zk, authSchema);
            CommandAuthTest.resetRootACL(this.zk);
        }
    }

    @ParameterizedTest
    @EnumSource(value=AuthSchema.class, names={"DIGEST"})
    public void testAuthCheck_notAuthorized(AuthSchema authSchema) throws Exception {
        this.setupRootACL(authSchema);
        try {
            HttpURLConnection authTestConn = this.sendAuthTestCommandRequest(authSchema, false);
            Assertions.assertEquals((int)403, (int)authTestConn.getResponseCode());
        }
        finally {
            this.addAuthInfo(this.zk, authSchema);
            CommandAuthTest.resetRootACL(this.zk);
        }
    }

    @ParameterizedTest
    @EnumSource(value=AuthSchema.class)
    public void testAuthCheck_noACL(AuthSchema authSchema) throws Exception {
        HttpURLConnection authTestConn = this.sendAuthTestCommandRequest(authSchema, false);
        Assertions.assertEquals((int)200, (int)authTestConn.getResponseCode());
    }

    @Test
    public void testAuthCheck_invalidServerRequiredConfig() {
        Assert.assertThrows((String)"An active server is required for auth check", IllegalArgumentException.class, () -> new AuthTestCommand(false, 31, "/"));
    }

    @Test
    public void testAuthCheck_noAuthInfo() {
        this.testAuthCheck_invalidAuthInfo(null);
    }

    @Test
    public void testAuthCheck_noAuthInfoSeparator() {
        String invalidAuthInfo = String.format("%s%s%s:%s", DIGEST_SCHEMA, "", ROOT_USER, ROOT_PASSWORD);
        this.testAuthCheck_invalidAuthInfo(invalidAuthInfo);
    }

    @Test
    public void testAuthCheck_invalidAuthInfoSeparator() {
        String invalidAuthInfo = String.format("%s%s%s:%s", DIGEST_SCHEMA, ":", ROOT_USER, ROOT_PASSWORD);
        this.testAuthCheck_invalidAuthInfo(invalidAuthInfo);
    }

    @Test
    public void testAuthCheck_invalidAuthSchema() {
        String invalidAuthInfo = String.format("%s%s%s:%s", "InvalidAuthSchema", " ", ROOT_USER, ROOT_PASSWORD);
        this.testAuthCheck_invalidAuthInfo(invalidAuthInfo);
    }

    @Test
    public void testAuthCheck_authProviderNotFound() {
        String invalidAuthInfo = String.format("%s%s%s:%s", "sasl", " ", ROOT_USER, ROOT_PASSWORD);
        this.testAuthCheck_invalidAuthInfo(invalidAuthInfo);
    }

    private void testAuthCheck_invalidAuthInfo(String invalidAuthInfo) {
        CommandResponse commandResponse = Commands.runGetCommand((String)AUTH_TEST_COMMAND_NAME, (ZooKeeperServer)this.zks, new HashMap(), (String)invalidAuthInfo, null);
        Assertions.assertEquals((int)401, (int)commandResponse.getStatusCode());
    }

    private void setupTLS() throws Exception {
        System.setProperty("zookeeper.authProvider.x509", "org.apache.zookeeper.server.auth.X509AuthenticationProvider");
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty(this.clientX509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(this.clientX509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty(this.clientX509Util.getSslTruststoreLocationProperty(), testDataPath + "/ssl/testTrustStore.jks");
        System.setProperty(this.clientX509Util.getSslTruststorePasswdProperty(), "testpass");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.client.portUnification", Boolean.TRUE.toString());
        System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(this.quorumX509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty(this.quorumX509Util.getSslTruststoreLocationProperty(), testDataPath + "/ssl/testTrustStore.jks");
        System.setProperty(this.quorumX509Util.getSslTruststorePasswdProperty(), "testpass");
        System.setProperty("zookeeper.admin.forceHttps", "true");
        System.setProperty("zookeeper.admin.needClientAuth", "true");
        SSLContext sslContext = SSLContext.getInstance(ClientX509Util.DEFAULT_PROTOCOL);
        X509AuthenticationProvider authProvider = (X509AuthenticationProvider)ProviderRegistry.getProvider((String)X509_SCHEMA);
        if (authProvider == null) {
            throw new X509Exception.SSLContextException("Could not create SSLContext with x509 auth provider");
        }
        sslContext.init(new X509KeyManager[]{authProvider.getKeyManager()}, new X509TrustManager[]{authProvider.getTrustManager()}, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
    }

    public void clearTLS() {
        System.clearProperty("zookeeper.authProvider.x509");
        System.clearProperty(this.clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(this.clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslTruststorePasswdProperty());
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.client.portUnification");
        System.clearProperty(this.quorumX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(this.quorumX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(this.quorumX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(this.quorumX509Util.getSslTruststorePasswdProperty());
        System.clearProperty("zookeeper.admin.forceHttps");
        System.clearProperty("zookeeper.admin.needClientAuth");
    }

    private void setupRootACL(AuthSchema authSchema) throws Exception {
        switch (authSchema) {
            case DIGEST: {
                CommandAuthTest.setupRootACLForDigest(this.zk);
                break;
            }
            case X509: {
                CommandAuthTest.setupRootACLForX509(this.zk);
                break;
            }
            case IP: {
                CommandAuthTest.setupRootACLForIP(this.zk);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown auth schema");
            }
        }
    }

    private HttpURLConnection sendAuthTestCommandRequest(AuthSchema authSchema, boolean validAuthInfo) throws Exception {
        URL authTestURL = new URL(String.format("https://localhost:%d/commands/authtest", this.jettyAdminPort));
        HttpURLConnection authTestConn = (HttpURLConnection)authTestURL.openConnection();
        CommandAuthTest.addAuthHeader(authTestConn, authSchema, validAuthInfo);
        authTestConn.setRequestMethod("GET");
        return authTestConn;
    }

    private void addAuthInfo(ZooKeeper zk, AuthSchema authSchema) {
        switch (authSchema) {
            case DIGEST: {
                CommandAuthTest.addAuthInfoForDigest(zk);
                break;
            }
            case X509: {
                CommandAuthTest.addAuthInfoForX509(zk);
                break;
            }
            case IP: {
                this.addAuthInfoForIP(zk);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown auth schema");
            }
        }
    }

    public static void resetRootACL(ZooKeeper zk) throws Exception {
        zk.setACL("/", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
    }

    public static void setupRootACLForDigest(ZooKeeper zk) throws Exception {
        String idPassword = String.format("%s:%s", ROOT_USER, ROOT_PASSWORD);
        String digest = DigestAuthenticationProvider.generateDigest((String)idPassword);
        ACL acl = new ACL(31, new Id(DIGEST_SCHEMA, digest));
        zk.setACL("/", Collections.singletonList(acl), -1);
    }

    private static void setupRootACLForX509(ZooKeeper zk) throws Exception {
        ACL acl = new ACL(31, new Id(X509_SCHEMA, X509_SUBJECT_PRINCIPAL));
        zk.setACL("/", Collections.singletonList(acl), -1);
    }

    private static void setupRootACLForIP(ZooKeeper zk) throws Exception {
        ACL acl = new ACL(31, new Id(IP_SCHEMA, "127.0.0.1"));
        zk.setACL("/", Collections.singletonList(acl), -1);
    }

    public static void addAuthInfoForDigest(ZooKeeper zk) {
        String idPassword = String.format("%s:%s", ROOT_USER, ROOT_PASSWORD);
        zk.addAuthInfo(DIGEST_SCHEMA, idPassword.getBytes(StandardCharsets.UTF_8));
    }

    public static void addAuthInfoForX509(ZooKeeper zk) {
        zk.addAuthInfo(X509_SCHEMA, X509_SUBJECT_PRINCIPAL.getBytes(StandardCharsets.UTF_8));
    }

    private void addAuthInfoForIP(ZooKeeper zk) {
        zk.addAuthInfo(IP_SCHEMA, "127.0.0.1".getBytes(StandardCharsets.UTF_8));
    }

    public static void addAuthHeader(HttpURLConnection conn, AuthSchema authSchema, boolean validAuthInfo) {
        String authInfo;
        switch (authSchema) {
            case DIGEST: {
                authInfo = validAuthInfo ? CommandAuthTest.buildAuthorizationForDigest() : CommandAuthTest.buildInvalidAuthorizationForDigest();
                break;
            }
            case X509: {
                authInfo = CommandAuthTest.buildAuthorizationForX509();
                break;
            }
            case IP: {
                authInfo = CommandAuthTest.buildAuthorizationForIP();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown auth schema");
            }
        }
        conn.setRequestProperty(HttpHeader.AUTHORIZATION.asString(), authInfo);
    }

    public static String buildAuthorizationForDigest() {
        return String.format("%s%s%s:%s", DIGEST_SCHEMA, " ", ROOT_USER, ROOT_PASSWORD);
    }

    private static String buildInvalidAuthorizationForDigest() {
        return String.format("%s%s%s:%s", DIGEST_SCHEMA, " ", "InvalidUser", "InvalidPassword");
    }

    private static String buildAuthorizationForX509() {
        return String.format("%s%s", X509_SCHEMA, " ");
    }

    private static String buildAuthorizationForIP() {
        return String.format("%s%s", IP_SCHEMA, " ");
    }

    private static class AuthTestCommand
    extends GetCommand {
        public AuthTestCommand(boolean serverRequired, int perm, String path) {
            super(Arrays.asList(CommandAuthTest.AUTH_TEST_COMMAND_NAME, "at"), serverRequired, new AuthRequest(perm, path));
        }

        public CommandResponse runGet(ZooKeeperServer zkServer, Map<String, String> kwargs) {
            return this.initializeResponse();
        }
    }

    public static enum AuthSchema {
        DIGEST,
        X509,
        IP;

    }
}

