/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.Arrays;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ObserverLETest
extends ZKTestCase {
    final QuorumBase qb = new QuorumBase();
    final ClientTest ct = new ClientTest();

    @BeforeEach
    public void establishThreeParticipantOneObserverEnsemble() throws Exception {
        this.qb.setUp(true, false);
        this.ct.hostPort = this.qb.hostPort;
        this.ct.setUpAll();
        this.qb.s5.shutdown();
    }

    @AfterEach
    public void shutdownQuorum() throws Exception {
        this.ct.tearDownAll();
        this.qb.tearDown();
    }

    @Test
    public void testLEWithObserver() throws Exception {
        QuorumPeer leader = null;
        for (QuorumPeer server : Arrays.asList(this.qb.s1, this.qb.s2, this.qb.s3)) {
            if (server.getServerState().equals("following")) {
                server.shutdown();
                Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + server.getClientPort(), ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server down");
                continue;
            }
            Assertions.assertNull(leader, (String)"More than one leader found");
            leader = server;
        }
        Assertions.assertTrue((boolean)ClientBase.waitForServerState(leader, ClientBase.CONNECTION_TIMEOUT, "leaderelection"), (String)"Leader is not in Looking state");
    }
}

