/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.IPAuthenticationProvider;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public class IPAuthTest {
    @Before
    public void setUp() {
        System.setProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor", "true");
    }

    @After
    public void tearDown() {
        System.clearProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor");
    }

    @Test
    public void testHandleAuthentication_Forwarded() {
        IPAuthenticationProvider provider = new IPAuthenticationProvider();
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String forwardedForHeader = "fc00:0:0:0:0:0:0:4, 192.168.0.6, 10.0.0.8, 172.16.0.9";
        ((HttpServletRequest)Mockito.doReturn((Object)"fc00:0:0:0:0:0:0:4, 192.168.0.6, 10.0.0.8, 172.16.0.9").when((Object)mockRequest)).getHeader("X-Forwarded-For");
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.0.5").when((Object)mockRequest)).getRemoteAddr();
        List<Id> expectedIds = Arrays.asList(new Id(provider.getScheme(), "fc00:0:0:0:0:0:0:4"));
        Assertions.assertEquals(expectedIds, (Object)provider.handleAuthentication(mockRequest, null));
    }

    @Test
    public void testHandleAuthentication_NoForwarded() {
        IPAuthenticationProvider provider = new IPAuthenticationProvider();
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)mockRequest)).getHeader("X-Forwarded-For");
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.0.6").when((Object)mockRequest)).getRemoteAddr();
        List<Id> expectedIds = Arrays.asList(new Id(provider.getScheme(), "192.168.0.6"));
        Assertions.assertEquals(expectedIds, (Object)provider.handleAuthentication(mockRequest, null));
    }
}

