/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.common.X509TestContext;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.server.quorum.UnifiedServerSocket;
import org.apache.zookeeper.test.ClientBase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedServerSocketModeDetectionTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(UnifiedServerSocketModeDetectionTest.class);
    private static File tempDir;
    private static X509TestContext x509TestContext;
    private X509Util x509Util;
    private UnifiedServerSocket listeningSocket;
    private UnifiedServerSocket.UnifiedSocket serverSideSocket;
    private Socket clientSocket;
    private ExecutorService workerPool;
    private int port;
    private InetSocketAddress localServerAddress;

    @BeforeAll
    public static void setUpClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        tempDir = ClientBase.createEmptyTestDir();
        x509TestContext = X509TestContext.newBuilder().setTempDir(tempDir).setKeyStoreKeyType(X509KeyType.EC).setTrustStoreKeyType(X509KeyType.EC).build();
    }

    @AfterAll
    public static void tearDownClass() {
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Security.removeProvider("BC");
    }

    private static void forceClose(Socket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void forceClose(ServerSocket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void init(boolean useSecureClient) throws Exception {
        this.x509Util = new ClientX509Util();
        x509TestContext.setSystemProperties(this.x509Util, KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), "100");
        this.workerPool = Executors.newCachedThreadPool();
        this.port = PortAssignment.unique();
        this.localServerAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), this.port);
        this.listeningSocket = new UnifiedServerSocket(this.x509Util, true);
        this.listeningSocket.bind((SocketAddress)this.localServerAddress);
        Future<UnifiedServerSocket.UnifiedSocket> acceptFuture = this.workerPool.submit(new Callable<UnifiedServerSocket.UnifiedSocket>(){

            @Override
            public UnifiedServerSocket.UnifiedSocket call() throws Exception {
                try {
                    return (UnifiedServerSocket.UnifiedSocket)UnifiedServerSocketModeDetectionTest.this.listeningSocket.accept();
                }
                catch (IOException e) {
                    LOG.error("Error in accept()", (Throwable)e);
                    throw e;
                }
            }
        });
        if (useSecureClient) {
            this.clientSocket = this.x509Util.createSSLSocket();
            this.clientSocket.connect(this.localServerAddress);
        } else {
            this.clientSocket = new Socket();
            this.clientSocket.connect(this.localServerAddress);
            this.clientSocket.getOutputStream().write(new byte[]{1, 2, 3, 4, 5});
        }
        this.serverSideSocket = acceptFuture.get();
    }

    @AfterEach
    public void tearDown() throws Exception {
        x509TestContext.clearSystemProperties(this.x509Util);
        System.clearProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty());
        UnifiedServerSocketModeDetectionTest.forceClose((ServerSocket)this.listeningSocket);
        UnifiedServerSocketModeDetectionTest.forceClose((Socket)this.serverSideSocket);
        UnifiedServerSocketModeDetectionTest.forceClose(this.clientSocket);
        this.workerPool.shutdown();
        this.workerPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        this.x509Util.close();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetInetAddress(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getInetAddress();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetLocalAddress(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getLocalAddress();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetPort(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getPort();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetLocalPort(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getLocalPort();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetRemoteSocketAddress(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getRemoteSocketAddress();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetLocalSocketAddress(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getLocalSocketAddress();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetInputStream(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getInputStream();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetOutputStream(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getOutputStream();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetTcpNoDelay(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getTcpNoDelay();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetTcpNoDelay(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        boolean tcpNoDelay = this.serverSideSocket.getTcpNoDelay();
        tcpNoDelay = !tcpNoDelay;
        this.serverSideSocket.setTcpNoDelay(tcpNoDelay);
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assertions.assertEquals((Object)tcpNoDelay, (Object)this.serverSideSocket.getTcpNoDelay());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetSoLinger(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getSoLinger();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetSoLinger(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        int soLinger = this.serverSideSocket.getSoLinger();
        if (soLinger == -1) {
            this.serverSideSocket.setSoLinger(true, 1);
            Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
            Assertions.assertEquals((int)1, (int)this.serverSideSocket.getSoLinger());
        } else {
            this.serverSideSocket.setSoLinger(false, -1);
            Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
            Assertions.assertEquals((int)-1, (int)this.serverSideSocket.getSoLinger());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetSoTimeout(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getSoTimeout();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetSoTimeout(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        int timeout = this.serverSideSocket.getSoTimeout();
        this.serverSideSocket.setSoTimeout(timeout += 10);
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assertions.assertEquals((int)timeout, (int)this.serverSideSocket.getSoTimeout());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetSendBufferSize(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getSendBufferSize();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetSendBufferSize(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.setSendBufferSize(this.serverSideSocket.getSendBufferSize() + 1024);
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetReceiveBufferSize(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getReceiveBufferSize();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetReceiveBufferSize(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.setReceiveBufferSize(this.serverSideSocket.getReceiveBufferSize() + 1024);
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetKeepAlive(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getKeepAlive();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetKeepAlive(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        boolean keepAlive = this.serverSideSocket.getKeepAlive();
        keepAlive = !keepAlive;
        this.serverSideSocket.setKeepAlive(keepAlive);
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assertions.assertEquals((Object)keepAlive, (Object)this.serverSideSocket.getKeepAlive());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetTrafficClass(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getTrafficClass();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetTrafficClass(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.setTrafficClass(3);
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetReuseAddress(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.getReuseAddress();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetReuseAddress(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        boolean reuseAddress = this.serverSideSocket.getReuseAddress();
        reuseAddress = !reuseAddress;
        this.serverSideSocket.setReuseAddress(reuseAddress);
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        Assertions.assertEquals((Object)reuseAddress, (Object)this.serverSideSocket.getReuseAddress());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testClose(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.close();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testShutdownInput(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.shutdownInput();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testShutdownOutput(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.shutdownOutput();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIsConnected(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.isConnected();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIsBound(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.isBound();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIsClosed(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.isClosed();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIsInputShutdown(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.isInputShutdown();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        this.serverSideSocket.shutdownInput();
        Assertions.assertTrue((boolean)this.serverSideSocket.isInputShutdown());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIsOutputShutdown(boolean useSecureClient) throws Exception {
        this.init(useSecureClient);
        this.serverSideSocket.isOutputShutdown();
        Assertions.assertFalse((boolean)this.serverSideSocket.isModeKnown());
        this.serverSideSocket.shutdownOutput();
        Assertions.assertTrue((boolean)this.serverSideSocket.isOutputShutdown());
    }
}

