/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster.standalone;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.cluster.standalone.StandaloneClusterControl;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class StandaloneAccumuloCluster
implements AccumuloCluster {
    static final List<ServerType> ALL_SERVER_TYPES = Collections.unmodifiableList(Arrays.asList(ServerType.MANAGER, ServerType.TABLET_SERVER, ServerType.GARBAGE_COLLECTOR, ServerType.MONITOR));
    private ClientInfo info;
    private String accumuloHome;
    private String clientAccumuloConfDir;
    private String serverAccumuloConfDir;
    private String hadoopConfDir;
    private Path tmp;
    private List<ClusterUser> users;
    private String clientCmdPrefix;
    private String serverCmdPrefix;
    private SiteConfiguration siteConfig;
    private ServerContext context;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    public StandaloneAccumuloCluster(ClientInfo info, Path tmp, List<ClusterUser> users, String serverAccumuloConfDir) {
        this.info = info;
        this.tmp = tmp;
        this.users = users;
        this.serverAccumuloConfDir = serverAccumuloConfDir;
        this.siteConfig = SiteConfiguration.fromFile((File)new File(serverAccumuloConfDir, "accumulo.properties")).build();
    }

    public String getAccumuloHome() {
        return this.accumuloHome;
    }

    public void setAccumuloHome(String accumuloHome) {
        this.accumuloHome = accumuloHome;
    }

    public String getClientAccumuloConfDir() {
        return this.clientAccumuloConfDir;
    }

    public void setClientAccumuloConfDir(String accumuloConfDir) {
        this.clientAccumuloConfDir = accumuloConfDir;
    }

    public String getServerAccumuloConfDir() {
        return this.serverAccumuloConfDir;
    }

    public void setServerCmdPrefix(String serverCmdPrefix) {
        this.serverCmdPrefix = serverCmdPrefix;
    }

    public void setClientCmdPrefix(String clientCmdPrefix) {
        this.clientCmdPrefix = clientCmdPrefix;
    }

    public String getHadoopConfDir() {
        if (this.hadoopConfDir == null) {
            this.hadoopConfDir = System.getenv("HADOOP_CONF_DIR");
        }
        if (this.hadoopConfDir == null) {
            throw new IllegalArgumentException("Cannot determine HADOOP_CONF_DIR for standalone cluster");
        }
        return this.hadoopConfDir;
    }

    public void setHadoopConfDir(String hadoopConfDir) {
        this.hadoopConfDir = hadoopConfDir;
    }

    @Override
    public String getInstanceName() {
        return this.info.getInstanceName();
    }

    @Override
    public String getZooKeepers() {
        return this.info.getZooKeepers();
    }

    @Override
    public synchronized ServerContext getServerContext() {
        if (this.context == null) {
            this.context = ServerContext.override((SiteConfiguration)this.siteConfig, (String)this.info.getInstanceName(), (String)this.info.getZooKeepers(), (int)this.info.getZooKeepersSessionTimeOut());
        }
        return this.context;
    }

    @Override
    public AccumuloClient createAccumuloClient(String user, AuthenticationToken token) {
        return (AccumuloClient)Accumulo.newClient().to((CharSequence)this.getInstanceName(), (CharSequence)this.getZooKeepers()).as((CharSequence)user, token).build();
    }

    @Override
    @Deprecated(since="2.0.0")
    public ClientConfiguration getClientConfig() {
        return ClientConfConverter.toClientConf((Properties)this.info.getProperties());
    }

    @Override
    public Properties getClientProperties() {
        return this.info.getProperties();
    }

    @Override
    public StandaloneClusterControl getClusterControl() {
        return new StandaloneClusterControl(this.accumuloHome, this.clientAccumuloConfDir, this.serverAccumuloConfDir, this.clientCmdPrefix, this.serverCmdPrefix);
    }

    @Override
    public void start() throws IOException {
        StandaloneClusterControl control = this.getClusterControl();
        control.setGoalState(ManagerGoalState.NORMAL.toString());
        for (ServerType type : ALL_SERVER_TYPES) {
            control.startAllServers(type);
        }
    }

    @Override
    public void stop() throws IOException {
        StandaloneClusterControl control = this.getClusterControl();
        for (ServerType type : ALL_SERVER_TYPES) {
            control.stopAllServers(type);
        }
    }

    public Configuration getHadoopConfiguration() {
        String confDir = this.getHadoopConfDir();
        Configuration conf = this.getServerContext().getHadoopConf();
        conf.addResource(new Path(confDir, "core-site.xml"));
        conf.addResource(new Path(confDir, "hdfs-site.xml"));
        return conf;
    }

    @Override
    public FileSystem getFileSystem() {
        Configuration conf = this.getHadoopConfiguration();
        try {
            return FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Path getTemporaryPath() {
        return this.getFileSystem().makeQualified(this.tmp);
    }

    public ClusterUser getUser(int offset) {
        Preconditions.checkArgument((offset >= 0 && offset < this.users.size() ? 1 : 0) != 0, (Object)("Invalid offset, should be non-negative and less than " + this.users.size()));
        return this.users.get(offset);
    }

    @Override
    public AccumuloConfiguration getSiteConfiguration() {
        return new ConfigurationCopy((Iterable)this.siteConfig);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    public String getAccumuloPropertiesPath() {
        return new File(this.serverAccumuloConfDir, "accumulo.properties").toString();
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input file name")
    public String getClientPropsPath() {
        return new File(this.clientAccumuloConfDir, "accumulo-client.properties").toString();
    }
}

