/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tablets;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.util.time.RelativeTime;

public abstract class TabletTime {
    public abstract void useMaxTimeFromWALog(long var1);

    public abstract MetadataTime getMetadataTime();

    public abstract MetadataTime getMetadataTime(long var1);

    public abstract long setUpdateTimes(List<Mutation> var1);

    public abstract long getTime();

    public abstract long getAndUpdateTime();

    protected void setSystemTimes(Mutation mutation, long lastCommitTime) {
        ServerMutation m = (ServerMutation)mutation;
        m.setSystemTimestamp(lastCommitTime);
    }

    public static TabletTime getInstance(MetadataTime metadataTime) throws IllegalArgumentException {
        if (metadataTime.getType().equals((Object)TimeType.LOGICAL)) {
            return new LogicalTime(metadataTime.getTime());
        }
        if (metadataTime.getType().equals((Object)TimeType.MILLIS)) {
            return new MillisTime(metadataTime.getTime());
        }
        throw new IllegalArgumentException("Time type unknown : " + String.valueOf(metadataTime));
    }

    public static MetadataTime maxMetadataTime(MetadataTime mv1, MetadataTime mv2) {
        if (mv1 == null || mv2 == null) {
            return mv1 == null ? (mv2 == null ? null : mv2) : mv1;
        }
        return mv1.compareTo(mv2) < 0 ? mv2 : mv1;
    }

    static class LogicalTime
    extends TabletTime {
        AtomicLong nextTime;

        private LogicalTime(Long time) {
            this.nextTime = new AtomicLong(time + 1L);
        }

        @Override
        public void useMaxTimeFromWALog(long time) {
            if (this.nextTime.get() < ++time) {
                this.nextTime.set(time);
            }
        }

        @Override
        public MetadataTime getMetadataTime() {
            return this.getMetadataTime(this.getTime());
        }

        @Override
        public MetadataTime getMetadataTime(long time) {
            return new MetadataTime(time, TimeType.LOGICAL);
        }

        @Override
        public long setUpdateTimes(List<Mutation> mutations) {
            if (mutations.isEmpty()) {
                return this.getTime();
            }
            long time = this.nextTime.getAndAdd(mutations.size());
            for (Mutation mutation : mutations) {
                this.setSystemTimes(mutation, time++);
            }
            return time - 1L;
        }

        @Override
        public long getTime() {
            return this.nextTime.get() - 1L;
        }

        @Override
        public long getAndUpdateTime() {
            return this.nextTime.getAndIncrement();
        }
    }

    static class MillisTime
    extends TabletTime {
        private long lastTime;
        private long lastUpdateTime = 0L;

        public MillisTime(long time) {
            this.lastTime = time;
        }

        @Override
        public MetadataTime getMetadataTime() {
            return this.getMetadataTime(this.lastTime);
        }

        @Override
        public MetadataTime getMetadataTime(long time) {
            return new MetadataTime(time, TimeType.MILLIS);
        }

        @Override
        public void useMaxTimeFromWALog(long time) {
            if (time > this.lastTime) {
                this.lastTime = time;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long setUpdateTimes(List<Mutation> mutations) {
            long currTime = RelativeTime.currentTimeMillis();
            MillisTime millisTime = this;
            synchronized (millisTime) {
                if (mutations.isEmpty()) {
                    return this.lastTime;
                }
                currTime = this.updateTime(currTime);
            }
            for (Mutation mutation : mutations) {
                this.setSystemTimes(mutation, currTime);
            }
            return currTime;
        }

        private long updateTime(long currTime) {
            if (currTime < this.lastTime) {
                if (currTime - this.lastUpdateTime > 0L) {
                    ++this.lastTime;
                }
                this.lastUpdateTime = currTime;
                currTime = this.lastTime;
            } else {
                this.lastTime = currTime;
            }
            return currTime;
        }

        @Override
        public long getTime() {
            return this.lastTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getAndUpdateTime() {
            long currTime = RelativeTime.currentTimeMillis();
            MillisTime millisTime = this;
            synchronized (millisTime) {
                currTime = this.updateTime(currTime);
            }
            return currTime;
        }
    }
}

